/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.MissingAttributeException;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import org.xml.sax.AttributeList;

class BooleanHandler
extends WddxElement {
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";

    BooleanHandler() {
    }

    @Override
    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        String value = attributes.getValue(VALUE_ATTRIBUTE_NAME);
        if (value == null) {
            throw new MissingAttributeException("boolean", VALUE_ATTRIBUTE_NAME);
        }
        if (value.equals(VALUE_TRUE)) {
            this.setValue(Boolean.TRUE);
        } else if (value.equals(VALUE_FALSE)) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new InvalidBooleanValueException();
        }
        this.setType(-7, "BOOLEAN");
    }

    public static class InvalidBooleanValueException
    extends WddxDeserializationException {
    }
}

