/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.xml.XmlNodeList;
import java.util.AbstractList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeArray
extends AbstractList {
    private Node node;
    protected boolean isCaseSensitive = false;
    private boolean childrenOnly = true;

    public XmlNodeArray(Node node, boolean childrenOnly) {
        this.node = node;
        this.childrenOnly = childrenOnly;
    }

    public void setCase(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public int size() {
        int size = 0;
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (this.childrenOnly) {
                if (list.item(i).getNodeType() != 1) continue;
                ++size;
                continue;
            }
            ++size;
        }
        return size;
    }

    private Node getChildrenNode(int idx) {
        int size = 0;
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            if (size == idx) {
                return list.item(i);
            }
            ++size;
        }
        throw new IndexOutOfBoundsException();
    }

    private Node getNode(int idx) {
        if (this.childrenOnly) {
            return this.getChildrenNode(idx);
        }
        NodeList list = this.node.getChildNodes();
        if (idx >= 0 && idx < list.getLength()) {
            return list.item(idx);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object get(int idx) {
        XmlNodeList xmlNodeList = new XmlNodeList(this.getNode(idx), this.isCaseSensitive);
        return xmlNodeList;
    }

    @Override
    public Object set(int i, Object obj) {
        if (!(obj instanceof XmlNodeList)) {
            throw new ClassCastException();
        }
        Node newNode = ((XmlNodeList)obj).getFirstNode();
        newNode = newNode.cloneNode(true);
        if (i < this.size()) {
            Node oldNode = this.getNode(i);
            this.node.replaceChild(newNode, oldNode);
            return oldNode;
        }
        this.node.appendChild(newNode);
        return newNode;
    }

    @Override
    public void add(int i, Object obj) {
        if (!(obj instanceof XmlNodeList)) {
            throw new ClassCastException();
        }
        Node newNode = ((XmlNodeList)obj).getFirstNode();
        newNode = newNode.cloneNode(true);
        if (i < this.size()) {
            Node oldNode = this.getNode(i);
            this.node.insertBefore(newNode, oldNode);
        } else {
            this.node.appendChild(newNode);
        }
    }

    @Override
    public Object remove(int i) {
        Node oldNode = this.getNode(i);
        this.node.removeChild(oldNode);
        return oldNode;
    }
}

