/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

public class MessageHandler {
    private static final MessageHandler instance = new MessageHandler();
    private static final String ERROR_MSG_FORMAT = "@|bold,red ERR: {content}|@";

    public static MessageHandler getInstance() {
        return instance;
    }

    private MessageHandler() {
    }

    public void showError(String message) {
        if (Objects.isNull(message)) {
            return;
        }
        String str = CommandLine.Help.Ansi.AUTO.string(ERROR_MSG_FORMAT.replace("{content}", message));
        System.out.println(str);
    }

    public void showError(Throwable e) {
        if (Objects.isNull(e)) {
            return;
        }
        String str = StringUtils.isNotBlank((CharSequence)e.getMessage()) ? CommandLine.Help.Ansi.AUTO.string(ERROR_MSG_FORMAT.replace("{content}", e.getMessage())) : CommandLine.Help.Ansi.AUTO.string(ERROR_MSG_FORMAT.replace("{content}", e.getClass().getName()));
        System.out.println(str);
    }

    public void showWarning(String message) {
        if (Objects.isNull(message)) {
            return;
        }
        String str = CommandLine.Help.Ansi.AUTO.string("@|yellow, WARN: {content}|@").replace("{content}", message);
        System.out.println(str);
    }

    public void showInfo(String message) {
        if (Objects.isNull(message)) {
            return;
        }
        System.out.println(message);
    }

    public void showInfo(String message, boolean newLine) {
        if (Objects.isNull(message)) {
            return;
        }
        if (!newLine) {
            System.out.print(message);
        } else {
            this.showInfo(message);
        }
    }

    public void showBoldRed(String message) {
        if (Objects.isNull(message)) {
            return;
        }
        String str = CommandLine.Help.Ansi.AUTO.string("@|bold,red {content}|@".replace("{content}", message));
        System.out.println(str);
    }

    public void showGreenAndBold(String message, boolean newLine) {
        String str = CommandLine.Help.Ansi.AUTO.string("@|bold,green, {content}|@").replace("{content}", message);
        if (newLine) {
            System.out.println(str);
        } else {
            System.out.print(str);
        }
    }

    public void showGreenAndBold(String message) {
        this.showGreenAndBold(message, true);
    }

    public void showWhiteAndBold(String message, boolean newLine) {
        if (Objects.isNull(message)) {
            return;
        }
        String str = CommandLine.Help.Ansi.AUTO.string("@|bold,white, {content}|@").replace("{content}", message);
        if (newLine) {
            System.out.println(str);
        } else {
            System.out.print(str);
        }
    }

    public void showGreen(String message, boolean newLine) {
        String str = CommandLine.Help.Ansi.AUTO.string("@|green, {content}|@").replace("{content}", message);
        if (newLine) {
            System.out.println(str);
        } else {
            System.out.print(str);
        }
    }

    public void showBlueAndBold(String message, boolean newLine) {
        if (Objects.isNull(message)) {
            return;
        }
        String str = CommandLine.Help.Ansi.AUTO.string("@|bold,blue, {content}|@").replace("{content}", message);
        if (newLine) {
            System.out.println(str);
        } else {
            System.out.print(str);
        }
    }
}

