/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup;

import coldfusion.runtime.Cast;
import coldfusion.scheduling.ScheduleTagData;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.EntryPoint;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.json.JsonUtil;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Util {
    private static Map<String, Boolean> categoriesMap = null;
    public static final String TAB = "\t";
    private static Map<String, Object> importSettingsMap = new HashMap<String, Object>();

    public static String getConfigHome() {
        return System.getProperty("configHome");
    }

    public static boolean isSettingValid(String setting) {
        for (Category xmlName : Category.values()) {
            if (!xmlName.name().toLowerCase().equals(setting)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(String instanceFileorCFHome) {
        return RegisterInstanceImpl.getAliasFromMap(instanceFileorCFHome) != null;
    }

    public static Object getValueByType(String type, Object value) {
        type = type.toLowerCase();
        if (Objects.isNull(value)) {
            return null;
        }
        try {
            switch (type) {
                case "int": {
                    Double doubleVal = new Double(Cast._double(value));
                    String double_str = BigDecimal.valueOf(doubleVal).toPlainString();
                    String v = Util.removeTrailingZeroesAfterDecimalForInteger(double_str);
                    String string = v = v != null && v.startsWith("-") ? v.substring(1) : v;
                    if (!NumberUtils.isDigits((String)v)) {
                        return null;
                    }
                    Long longValue = doubleVal.longValue();
                    return longValue > Integer.MAX_VALUE ? null : Integer.valueOf(longValue.intValue());
                }
                case "double": {
                    return Cast._double(value);
                }
                case "string": {
                    return Cast._String(value);
                }
                case "boolean": {
                    return Cast._boolean(value);
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new CFSetupException(Messages.getString("invalidValueOfType", type));
        }
    }

    public static boolean isValidCategoryOrAll(List<String> args) {
        if (args.get(0).equals("all")) {
            return args.size() == 1;
        }
        for (String category : args) {
            Category.of(category);
        }
        return true;
    }

    public static String trimQuotes(String v) {
        if (v.startsWith("'") && v.endsWith("'") || v.startsWith("\"") && v.endsWith("\"")) {
            v = v.substring(1, v.length() - 1);
        }
        return v.trim();
    }

    private static Map<String, Boolean> getEnabledCategories(String cfhome) {
        if (categoriesMap != null) {
            return categoriesMap;
        }
        try {
            File jsonFile = new File(Util.getConfigHome() + File.separator + "Categories.json");
            categoriesMap = (HashMap)JsonUtil.getJsonObjectMapper().readValue(jsonFile, Map.class);
            return categoriesMap;
        }
        catch (Exception jsonFile) {
            HashMap<String, Boolean> newCategoriesMap;
            HashMap<String, Boolean> hashMap = newCategoriesMap = categoriesMap == null ? new HashMap<String, Boolean>() : new HashMap<String, Boolean>(categoriesMap);
            if (Util.isJEEDeployment(cfhome)) {
                newCategoriesMap.put(Category.JVM.name(), false);
                newCategoriesMap.put(Category.SERVER.name(), false);
            }
            return Collections.unmodifiableMap(newCategoriesMap);
        }
    }

    public static boolean isCategoryDisabled(String cfhome, String c) {
        Map<String, Boolean> categoriesMap = Util.getEnabledCategories(cfhome);
        return categoriesMap.containsKey(c) && categoriesMap.get(c) == false;
    }

    public static boolean validateExecutionPath(File executionFile) {
        return Objects.nonNull(executionFile) && executionFile.exists() && Util.validCFHome(executionFile);
    }

    public static boolean validCFHome(File executionFile) {
        return Objects.nonNull(executionFile) && executionFile.exists() && executionFile.isDirectory() && Objects.nonNull(executionFile.list()) && new HashSet<String>(Arrays.asList(executionFile.list())).containsAll(Arrays.asList("bin", "lib"));
    }

    public static String getIntervalNumberFromString(String interval) {
        String[] splitted = interval.split(":");
        int hour = 0;
        int minute = 0;
        int second = 0;
        String num1 = "0";
        String num2 = "0";
        String num3 = "0";
        boolean convertible = true;
        if (splitted.length > 0) {
            num1 = Util.removeTrailingZeroesAfterDecimal(splitted[0]);
        }
        if (splitted.length > 1) {
            num2 = Util.removeTrailingZeroesAfterDecimal(splitted[1]);
        }
        if (splitted.length > 2) {
            num3 = Util.removeTrailingZeroesAfterDecimal(splitted[2]);
        }
        boolean bl = convertible = NumberUtils.isDigits((String)num1) && NumberUtils.isDigits((String)num2) && NumberUtils.isDigits((String)num3);
        if (convertible && splitted.length == 1) {
            boolean bl2 = convertible = Long.valueOf(num1) != 0L;
        }
        if (!convertible) {
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", ScheduleTagData.INTERVAL));
            throw new CFSetupException(Messages.getString("invalidAttributeVal", ScheduleTagData.INTERVAL));
        }
        if (splitted.length == 1) {
            return interval;
        }
        hour = (int)Double.parseDouble(num1);
        minute = (int)Double.parseDouble(num2);
        second = (int)Double.parseDouble(num3);
        return String.valueOf(second + 60 * minute + 3600 * hour);
    }

    public static Map<String, Object> createFlatMap(Category category, Map<String, Map<String, Object>> settingConfigmap) {
        TreeMap<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        settingConfigmap.forEach((service, cloudConfig) -> {
            HashMap flatConfig = new HashMap();
            flatMap.put((String)service, flatConfig);
            ProposedSetting.getInstance().getCategoryProposedSettingMap(category).keySet().forEach(actualKey -> {
                Object value = Util.getSettingValue(actualKey, service, settingConfigmap);
                if (Objects.nonNull(value)) {
                    flatConfig.put(actualKey, value);
                }
            });
        });
        return flatMap;
    }

    public static Map<String, Object> getInternalMap(Map<String, Object> flatMap, Category category) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        flatMap.forEach((configAlias, flatConfig) -> {
            HashMap configMap = new HashMap();
            map.put((String)configAlias, configMap);
            ((Map)flatConfig).forEach((actualKey, value) -> {
                String userDefinedKey = ProposedSetting.getInstance().getUserDefinedValue(category, (String)actualKey);
                String[] order = actualKey.split("/");
                Map settingMap = configMap;
                for (int i = 0; i < order.length - 1; ++i) {
                    HashMap settingValue;
                    if (settingMap.containsKey(order[i])) {
                        settingValue = settingMap.get(order[i]);
                    } else {
                        settingValue = new HashMap();
                        settingMap.put(order[i], settingValue);
                    }
                    settingMap = settingValue;
                }
                settingMap.put(userDefinedKey, value);
            });
        });
        return map;
    }

    public static Object getSettingValue(String name, String service, Map<String, Map<String, Object>> configMap) {
        Map cloudConfig;
        String[] order = name.split("/");
        Map settingMap = cloudConfig = configMap.get(service);
        for (String settingName : order) {
            Object settingValue = settingMap.get(settingName);
            if (settingValue instanceof Map) {
                settingMap = (Map)settingValue;
                if (!"headers".equalsIgnoreCase(settingName)) continue;
                return settingValue;
            }
            return settingValue;
        }
        return null;
    }

    public static Map<String, Object> expandNestedFields(Map<String, Object> map) {
        HashMap<String, Object> expandedMap = new HashMap<String, Object>();
        map.forEach((name, value) -> {
            String[] order = name.split("/");
            Map settingMap = expandedMap;
            for (int i = 0; i < order.length - 1; ++i) {
                HashMap settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put(settingKey, value);
        });
        return expandedMap;
    }

    public static boolean isEmptyValInMap(Map<String, Object> map, String key) {
        Object v = map.get(key);
        return v instanceof String ? org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)v)) : v == null;
    }

    public static Integer getInt(Object value) {
        return Objects.isNull(value) ? null : Integer.valueOf(Integer.parseInt(String.valueOf(value)));
    }

    public static String getString(Object value) {
        return Objects.isNull(value) ? null : String.valueOf(value);
    }

    public static Pair<GenericSetting, String> getExternalDependency(Category category, String key, File executionPath) {
        Pair genericSettingKeyPair = null;
        ValidationDetails vd = SettingValidation.getInstance().getValidationDetail(category, key);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vd.getExternal())) {
            String externalKey = vd.getExternal();
            Category externalCategory = Category.getCategory(externalKey.split("\\.")[0]).get();
            key = externalKey.substring(externalKey.indexOf(".") + 1);
            GenericSetting genericSetting = SettingInstanceProvider.getInstance().getCategoryInstance(executionPath, externalCategory, false);
            genericSettingKeyPair = Pair.of((Object)genericSetting, (Object)key);
        }
        return genericSettingKeyPair;
    }

    public static String removeTrailingZeroesAfterDecimal(String s) {
        if (Pattern.matches("[0-9]+\\.0+$", s)) {
            s = s.split("\\.")[0];
        }
        return s;
    }

    public static String removeTrailingZeroesAfterDecimalForInteger(String s) {
        if (Pattern.matches("[-]?[0-9]+\\.0+$", s)) {
            s = s.split("\\.")[0];
        }
        return s;
    }

    public static boolean isJEEDeployment(String cfhome) {
        return !new File(cfhome + File.separator + "bin" + File.separator + Category.JVM.getFileName()).exists() || !new File(cfhome + File.separator + "runtime" + File.separator + "conf" + File.separator + Category.SERVER.getFileName()).exists();
    }

    public static String getPassphrase() throws IOException {
        if (EntryPoint.isNonInteractive) {
            return "";
        }
        String line = EntryPoint.getCommand().getReader().readLine(Messages.getString("providePassphrase"), Character.valueOf('*'));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)line)) {
            return "";
        }
        if (!Util.isValidPassprase(line)) {
            throw new CFSetupException(Messages.getString("invalidPassphrase"));
        }
        return line;
    }

    private static String passphrasePadding(String passphrase) {
        if (((String)(passphrase = ((String)passphrase).trim())).length() == 0) {
            throw new CFSetupException("invalidPassphrase");
        }
        while (((String)passphrase).length() < 16) {
            passphrase = (String)passphrase + (String)passphrase;
        }
        passphrase = ((String)passphrase).substring(0, 16);
        return passphrase;
    }

    public static Object encryptMap(String passphrase, Map<String, Object> settingMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)passphrase)) {
            MessageHandler.getInstance().showWarning(Messages.getString("passphraseMissing"));
            return settingMap;
        }
        SecretKeySpec aesKey = new SecretKeySpec(Util.passphrasePadding(passphrase).getBytes(), "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] out = cipher.doFinal(new Gson().toJson(settingMap).getBytes());
            return Base64.getEncoder().encodeToString(out);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CFSetupException("errorEncryptingUsingPassword", e);
        }
    }

    public static Map<String, String> decryptMap(String passphrase, String encryptedString) {
        SecretKeySpec aesKey = new SecretKeySpec(Util.passphrasePadding(passphrase).getBytes(), "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            byte[] out = cipher.doFinal(Base64.getDecoder().decode(encryptedString));
            return (Map)new Gson().fromJson(new String(out), Map.class);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CFSetupException(Messages.getString("errorDecryptingUsingPassword"), e);
        }
    }

    public static boolean isValidPassprase(String passphrase) {
        return org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{passphrase}) && passphrase.trim().length() >= 6;
    }

    public static void showExitMessage(ExitStatus status) {
        if (!EntryPoint.isNonInteractive) {
            return;
        }
        if (status == ExitStatus.FAIL) {
            MessageHandler.getInstance().showBoldRed("ExitStatus: " + status.name());
        } else {
            MessageHandler.getInstance().showGreen("ExitStatus: " + status.name(), true);
        }
    }

    public static void showSingleSetting(Category category, String actualSettingName, String value) {
        MessageHandler.getInstance().showGreenAndBold(org.apache.commons.lang3.StringUtils.capitalize((String)category.name().toLowerCase().concat(" setting(s)")), true);
        MessageHandler.getInstance().showGreen(TAB + ProposedSetting.getInstance().getUserDefinedValue(category, actualSettingName) + ": ", false);
        MessageHandler.getInstance().showInfo(value);
    }

    public static String getServiceName(String key, Map<String, ?> keyValueMap, Category category) {
        if (category == Category.SCHEDULETASK) {
            String groupName = keyValueMap.get("group") == null ? "default" : (String)keyValueMap.get("group");
            String mode = keyValueMap.get("mode") == null ? "server" : (String)keyValueMap.get("mode");
            String appname = keyValueMap.get("appname") == null ? "" : (String)keyValueMap.get("appname");
            String task = (String)keyValueMap.get("task");
            Object appnameAppender = "server".equalsIgnoreCase(mode) ? "" : ":" + appname;
            return (task + ":" + groupName + ":" + mode + (String)appnameAppender).toUpperCase();
        }
        return String.valueOf(keyValueMap.get(key));
    }

    public static void parseUserList(Map map, String key, Object value) {
        String v = (String)value;
        String[] valueAr = v.split(",");
        if (valueAr.length > 1 && AbstractCommand.commandName == CommandName.IMPORT) {
            if (key.equalsIgnoreCase("java.net.SocketPermission") || key.equalsIgnoreCase("coldfusion.vfs.VFilePermission") || key.equalsIgnoreCase("java.io.FilePermission") || key.equalsIgnoreCase("java.util.PropertyPermission") || key.equals("org.osgi.framework.ServicePermission")) {
                ArrayList<String> list = (ArrayList<String>)map.get(key);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add((String)value);
                map.put(key, list);
            }
        } else {
            List<String> valueList = Arrays.asList(valueAr);
            if (map.get(key) == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(valueList);
                map.put(key, list);
            } else {
                ((List)map.get(key)).addAll(valueList);
            }
        }
    }

    public static void addListToMap(Map map, String key, Object value) {
        if (map.get(key) == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)value);
            map.put(key, list);
        } else {
            ((List)map.get(key)).add((String)value);
        }
    }

    public static void updateListToSet(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            if (!(object instanceof List)) continue;
            map.put(key, new HashSet((List)object));
        }
    }

    public static String addFileSeparator(String file) {
        if (!(((String)file).endsWith("/") || ((String)file).endsWith("\\") || ((String)file).endsWith("-"))) {
            file = ((String)file).contains("/") ? (String)file + "/" : (((String)file).contains("\\") ? (String)file + "\\" : (String)file + File.separator);
        }
        return file;
    }

    public static Map getSandboxMap(Map<String, Object> map, String directory) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)directory)) {
            return null;
        }
        File f = new File(directory);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            File f2 = new File(entry.getKey());
            if (!f.equals(f2)) continue;
            return (Map)entry.getValue();
        }
        return null;
    }

    public static Object getFilePermissionsValue(String p) {
        ArrayList<String> permission = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p)) {
            return p;
        }
        String permissionKey = p;
        if (!(p.contains(",") || p.equalsIgnoreCase("read") || p.equalsIgnoreCase("write") || p.equalsIgnoreCase("execute") || p.equalsIgnoreCase("delete"))) {
            if (p.contains("r")) {
                permission.add("read");
            }
            if (p.contains("w")) {
                permission.add("write");
            }
            if (p.contains("x")) {
                permission.add("execute");
            }
            if (p.contains("d")) {
                permission.add("delete");
            }
            permissionKey = org.apache.commons.lang3.StringUtils.join(permission, (String)",");
        }
        return permissionKey;
    }

    public static void printAllowedValues(String settingName, Collection collection) {
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            MessageHandler.getInstance().showError(Messages.getString("allowedValuesForSetting", settingName, StringUtils.join((Collection)collection, (String)", ")));
        } else {
            MessageHandler.getInstance().showError(Messages.getString("noAllowedValuesForSetting", settingName));
        }
    }

    public static void setImportSettingsMap(Map<String, Object> importSettings) {
        importSettingsMap = importSettings;
    }

    public static Map<String, Object> getImportSettingsMap() {
        return importSettingsMap;
    }

    public static boolean isValidPort(String port) {
        try {
            int validPort = Integer.parseInt(port);
            return validPort > 0 && validPort <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Duration getDurationProperty(Object val) {
        String stringDuration = Cast._String(val);
        int length = stringDuration.length();
        String unit = stringDuration.substring(length - 1);
        long response = 1L;
        response = Long.parseLong(stringDuration.substring(0, length - 1));
        switch (unit) {
            case "m": {
                return Duration.ofMillis(response);
            }
            case "M": {
                return Duration.ofMinutes(response);
            }
            case "d": {
                return Duration.ofDays(response);
            }
            case "h": {
                return Duration.ofHours(response);
            }
            case "s": {
                return Duration.ofSeconds(response);
            }
            case "n": {
                return Duration.ofNanos(response);
            }
        }
        return null;
    }
}

