/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

public class CommandHelpRenderer
implements CommandLine.IHelpSectionRenderer {
    private static String prefix = "Command to add an instance of a category.";
    private static Map<Category, List<String>> addExamples = new HashMap<Category, List<String>>();
    private static Map<String, String> commandExamples;

    public String render(CommandLine.Help help) {
        CommandLine.Model.CommandSpec spec = help.commandSpec();
        String commandName = spec.name();
        Object msg = "";
        if ("add".equalsIgnoreCase(commandName)) {
            Category category = (Category)((Object)((CommandLine.Model.ArgSpec)spec.requiredArgs().get(1)).getValue());
            msg = prefix;
            if (addExamples.containsKey((Object)category)) {
                msg = ((String)msg).replace("category", category.name().toLowerCase());
                msg = (String)msg + "\n" + CommandHelpRenderer.getAddHelpMessage(category);
            } else if (category != null) {
                msg = Messages.getString("operationNotSupported2", category.name());
            }
            ((CommandLine.Model.ArgSpec)spec.requiredArgs().get(1)).setValue(null);
        } else if (commandExamples.containsKey(commandName)) {
            String desc = spec.usageMessage().description()[0];
            msg = String.format(desc.substring(0, desc.indexOf(Messages.getString("usage"))) + CommandHelpRenderer.getUserDefinedExample(commandExamples.get(commandName)) + System.lineSeparator(), new Object[0]);
        } else {
            msg = spec.usageMessage().description()[0];
        }
        if ("add".equalsIgnoreCase(commandName) || "delete".equalsIgnoreCase(commandName)) {
            String supportedCategories = StringUtils.join((Iterable)Arrays.stream(Category.values()).filter(c -> c.isMultiLevel() || c == Category.SOLR || c == Category.LDAPCONFIG || c == Category.SAMLCONFIG).map(c -> c.name().toLowerCase()).sorted().collect(Collectors.toList()), (String)", ");
            msg = (String)msg + String.format(Messages.getString("supportedCategories", supportedCategories), new Object[0]);
        }
        if ("add".equalsIgnoreCase(commandName) || "set".equalsIgnoreCase(commandName) || "import".equalsIgnoreCase(commandName)) {
            msg = (String)msg + String.format(Messages.getString("cfsetupNotes"), new Object[0]);
        }
        return msg;
    }

    public static String getAddHelpMessage(Category category) {
        Object message = "";
        if (!addExamples.containsKey((Object)category)) {
            message = Messages.getString("operationNotSupported2", category.name());
        } else {
            int i = 1;
            for (String example : addExamples.get((Object)category)) {
                message = (String)message + "\nExample" + i++ + ": add " + category.name().toLowerCase() + " " + CommandHelpRenderer.getUserDefinedExampleForAdd(example, category) + "\n";
            }
        }
        return message;
    }

    public static String getCommandHelpMessage(String commandName) {
        StringBuilder message = new StringBuilder();
        if (!commandExamples.containsKey(commandName)) {
            message.append(Messages.getString("HELP.invalidCommandCategory", commandName));
        } else {
            message.append(commandExamples.get(commandName));
        }
        return message.toString();
    }

    private static String getUserDefinedExampleForAdd(String example, Category category) {
        Object res = "";
        Object k = "";
        boolean isKeyPart = true;
        for (int i = 0; i < example.length(); ++i) {
            if (example.charAt(i) != ' ' && example.charAt(i) != '=' && isKeyPart) {
                k = (String)k + example.charAt(i);
                continue;
            }
            if (isKeyPart) {
                if (example.charAt(i) == '=') {
                    res = (String)res + ProposedSetting.getInstance().getUserDefinedValue(category, (String)k);
                    isKeyPart = false;
                } else {
                    res = (String)res + (String)k;
                }
                k = "";
            }
            res = (String)res + example.charAt(i);
            if (example.charAt(i) != ' ') continue;
            isKeyPart = true;
        }
        if (!StringUtils.isEmpty((CharSequence)k)) {
            res = (String)res + (String)k;
        }
        return res;
    }

    public static String getUserDefinedExample(String example) {
        Object res = "";
        Object k = "";
        boolean iskeyPart = false;
        for (int i = 0; i < example.length(); ++i) {
            if (example.charAt(i) == '}') {
                res = (String)res + ProposedSetting.getInstance().getUserDefinedValue(Category.DATASOURCE, (String)k);
                iskeyPart = false;
                k = "";
                continue;
            }
            if (iskeyPart) {
                k = (String)k + example.charAt(i);
                continue;
            }
            if (example.charAt(i) == '{') {
                iskeyPart = true;
                continue;
            }
            res = (String)res + example.charAt(i);
        }
        return res;
    }

    public static Map usageMap() {
        HashMap<String, String> usage = new HashMap<String, String>();
        usage.put("help", "help [<category>|<command>]");
        usage.put("show", "show {<category>|category} [<servicename>] [<cfusionHome|aliasname>]");
        usage.put("set", "set <category> [<servicename>] <settingKey=settingVal> [<cfusionHome|aliasname>]");
        usage.put("version", "v");
        usage.put("v", "v");
        usage.put("select", "select <aliasname>");
        usage.put("deselect", "deselect");
        usage.put("import", "import <category> <jsonfile> [<jee.port=port & jee.contextroot=value>] [<aliasName|cfusionhome>]");
        usage.put("export", "export <category1,category2> <jsonfile> [<cfhome|aliasname>]");
        usage.put("get", "get <category> [<servicename>] <settingKey> [<aliasname|cfusionhome>]");
        usage.put("exit", "exit");
        usage.put("quit", "exit");
        usage.put("q", "exit");
        usage.put("clear", "cls");
        usage.put("cls", "cls");
        usage.put("which", "which");
        usage.put("delete", "delete <category> [<serviceName>] [<aliasName|cfusionHome>]");
        usage.put("alias", "alias <alias name> [<cfhome>]");
        usage.put("add", "add <category> <settingKey..>=<setting value..> ..* [<aliasName|cfusionHome>]");
        if (AbstractCommand.isLambdaMode()) {
            usage.put("show", "show {<category>|category} [<servicename>] ");
            usage.put("set", "set <category> [<servicename>] <settingKey=settingVal> ");
            usage.put("import", "import <category> <jsonfile> [<jee.port=port & jee.contextroot=value>]");
            usage.put("export", "export <category1,category2> <jsonfile> ");
            usage.put("get", "get <category> [<servicename>] <settingKey> ");
            usage.put("delete", "delete <category> [<serviceName>]");
            usage.put("add", "add <category> <settingKey..>=<setting value..> ..* ");
            usage.remove("alias");
            usage.remove("select");
            usage.remove("deselect");
        }
        return usage;
    }

    public static void setDescription(CommandLine cmd) {
        cmd.getSubcommands().forEach((k, v) -> v.getCommandSpec().usageMessage().description(new String[]{Messages.getString(k + ".description") + Messages.getString("usage") + ": " + CommandHelpRenderer.usageMap().get(k) + String.format("%n", new Object[0])}));
    }

    public static List<String> getCustomSynopsis(String commandName) {
        if (AbstractCommand.isLambdaMode()) {
            switch (commandName) {
                case "get": {
                    return Arrays.asList("get <category> <settingKey> ", "get <category> <servicename> <settingKey> ");
                }
                case "set": {
                    return Arrays.asList("set category <settingKey=settingValue> ", "set category <servicename> <settingKey=settingValue> ");
                }
                case "add": {
                    return Arrays.asList("add <category> <settingKey1>=<setting value1> <settingKey..>=<setting value..> ..* ");
                }
                case "delete": {
                    return Arrays.asList("delete <category> <servicename>", "delete <category> <servicename> ");
                }
                case "export": {
                    return Arrays.asList("export <category> <jsonfile> ", "export <category1,category2> <jsonfile> ", "export all <jsonfile> ");
                }
                case "import": {
                    return Arrays.asList("import <category> <jsonfile> [<jee.port=port & jee.contextroot=value>]", "import <category1,category2> <jsonfile> [<jee.port=port & jee.contextroot=value>]", "import all <jsonfile> [<jee.port=port & jee.contextroot=value>]");
                }
                case "show": {
                    return Arrays.asList("show <category> <servicename>", "show <category>", "show all ", "show category");
                }
                case "alias": {
                    return Arrays.asList("alias <alias name> <cfhome>", "alias -[d | delete] <alias name>", "alias -[u | update] <alias name> <cfhome>");
                }
            }
            return new LinkedList<String>();
        }
        switch (commandName) {
            case "get": {
                return Arrays.asList("get <category> <settingKey> [<aliasName>|<cfhome>]", "get <category> <servicename> <settingKey> [<aliasName>|<cfhome>]");
            }
            case "set": {
                return Arrays.asList("set category <settingKey=settingValue> [<aliasName>|<cfhome>]", "set category <servicename> <settingKey=settingValue> [<aliasName>|<cfhome>]");
            }
            case "add": {
                return Arrays.asList("add <category> <settingKey1>=<setting value1> <settingKey..>=<setting value..> ..* [<aliasName>|<cfhome>]");
            }
            case "delete": {
                return Arrays.asList("delete <category> <servicename>", "delete <category> <servicename> [<aliasName>|<cfhome>]");
            }
            case "export": {
                return Arrays.asList("export <category> <jsonfile> [<aliasName>|<cfhome>]", "export <category1,category2> <jsonfile> [<aliasName>|<cfhome>]", "export all <jsonfile> [<aliasName>|<cfhome>]");
            }
            case "import": {
                return Arrays.asList("import <category> <jsonfile> [<jee.port=port & jee.contextroot=value>] [<aliasName>|<cfhome>]", "import <category1,category2> <jsonfile> [<jee.port=port & jee.contextroot=value>] [<aliasName>|<cfhome>]", "import all <jsonfile> [<jee.port=port & jee.contextroot=value>] [<aliasName>|<cfhome>]");
            }
            case "show": {
                return Arrays.asList("show <category> <servicename> [<cfhome>|<aliasName>]", "show <category> [<cfhome>|<aliasName>]", "show all [<cfhome>|<aliasName>]", "show alias", "show category");
            }
        }
        return new LinkedList<String>();
    }

    static {
        addExamples.put(Category.SCHEDULETASK, Arrays.asList("task=cron-task start_date=20/02/2020 start_time=\"10:49:46 AM\" url=http://localhost:8500/CFIDE/administrator/ interval=ONCE", "task=cron-task start_date=20/02/2020 start_time=\"10:49:46 AM\" url=http://localhost:8500/CFIDE/administrator/ "));
        addExamples.put(Category.DATASOURCE, Arrays.asList("NAME=cfartgallery DRIVER=\"APACHE DERBY EMBEDDED\" urlmap/database=C:\\ColdFusion2021\\db\\cfartgallery urlmap/isnewdb=false", "NAME=oracle_db DRIVER=oracle urlmap/SID=sid urlmap/host=localhost urlmap/port=1655 username=cfuser password=cf123"));
        addExamples.put(Category.REST, Arrays.asList("rootPath=C:\\ColdFusion2021\\portfolio mapping=portfolio isDefault=false host=localhost"));
        addExamples.put(Category.PROBE, Arrays.asList("name=aProbe URL=http://localhost:8503/probe.cfm INTERVAL=3600 START_TIME='10:00 AM'"));
        addExamples.put(Category.WEBSERVICE, Arrays.asList("name=weather-forecast authtype=NONE version=2  url=http://wsf.cdyne.com/WeatherWS/Weather.asmx?WSDL"));
        addExamples.put(Category.MAPPING, Arrays.asList("virtual=/CFIDE physical=M:\\cfusion\\wwwroot\\CFIDE\\"));
        addExamples.put(Category.EVENTGATEWAYINSTANCE, Arrays.asList("GATEWAYID=dummy_gateway_id MODE=MANUAL TYPE=instancetype CFCPATHS=cfclocation CONFIGURATIONPATH=cfg_path"));
        addExamples.put(Category.EVENTGATEWAYTYPE, Arrays.asList("CLASS=<locationOfClass> DESCRIPTION=\"description goes here\" TYPE=EVENTTYPE STARTTIMEOUT=25.0 KILLONTIMEOUT=false"));
        addExamples.put(Category.PDFSERVICE, Arrays.asList("name=pdfsvc islocal=false hostname=10.10.31.5 port=8991 weight=1 ishttps=false isenabled=true "));
        addExamples.put(Category.NOSQL, Arrays.asList("name=datasourceName host=host type=mongodb"));
        addExamples.put(Category.SOLR, Arrays.asList("language name=Italian suffix=it"));
        addExamples.put(Category.CUSTOMTAG, Arrays.asList("customTagPath=C:\\ColdFusion\\tag\\folder\\path"));
        addExamples.put(Category.JVM, Arrays.asList("jvmArgs=<string_to_be_appended_in_jvmargs>"));
        addExamples.put(Category.SPCONFIGURATION, Arrays.asList("name=new_sp acsUrl=http:\\acsurl.com signKeystorePassword=pass entityId=eid"));
        addExamples.put(Category.CLOUDCREDENTIAL, Arrays.asList("vendorName=vname alias=aliasname region=\"us-east-1a\" "));
        addExamples.put(Category.CLOUDCONFIGURATION, Arrays.asList("alias=aliasname serviceName=serviceName "));
        addExamples.put(Category.IDPCONFIGURATION, Arrays.asList("name=idp_with_url description=\"description here\" signRequests=false encryptRequests=false metadataUrl=https://metadata.url", "name=idp_with_file description=\"description here\" signRequests=false encryptRequests=false metadataFilePath=metadataPath.xml"));
        addExamples.put(Category.USER, Arrays.asList("username=dummy_user description='a new user' password=pass"));
        addExamples.put(Category.SANDBOX, Arrays.asList("directory=M:\\cfusion\\dir java.io.FilePermission=rwx;M:\\cfusion\\a.cfm"));
        addExamples.put(Category.LDAPCONFIG, Arrays.asList("host=localhost port=10389 userBaseContext=ou=users,dc=example,dc=com groupBaseContext=ou=groups,dc=example,dc=com usernameAttr=uid groupnameAttr=cn timeout=1000", "host=localhost port=10389 userBaseContext=ou=users,dc=example,dc=com groupBaseContext=ou=groups,dc=example,dc=com usernameAttr=uid groupnameAttr=cn timeout=1000 credentials=userbindDN;password"));
        addExamples.put(Category.SAMLCONFIG, Arrays.asList("idpName=idp spName=sp groupName=groupName"));
        addExamples.put(Category.CLIENTVARIABLE, Arrays.asList("name=datasourceName description='JDBC datasource based client store' timeout=10 disable_globals=true"));
        commandExamples = new HashMap<String, String>();
        commandExamples.put("help", "\nExample 1: help datasource\nExample 2: help datasource {urlmap/port}");
        commandExamples.put("get", "\nExample 1: get datasource datasourcename {urlmap/port}\nExample 2: get debug ajax_enabled\nExample 3: get clientvariable purgeintervalinminutes");
        commandExamples.put("set", "\nExample 1: set datasource datasourcename {urlmap/port}=3161 \nExample 2: set datasource cfartgallery {urlmap/port}=3161 {timeout}=10\nExample 3: set debug ajax_enabled=true\nExample 4: set clientvariable clientstore=cookie\nExample 5: set clientvariable cookie purgeDataUnvisitedForDays=80\n");
        commandExamples.put("select", "\nExample: select cfusion\n");
        commandExamples.put("deselect", "\nExample: deselect\n");
        commandExamples.put("alias", "\nExample 1: alias cfusion /opt/coldfusion2021/cfusion\nExample 2: alias -u cfusion /opt/coldfusion2021/cfusion1\nExample 3: alias -d cfusion");
        commandExamples.put("show", "Example 1: show datasource \nExample 2: show datasource datasourcename\nExample 3: show runtime \nExample 4: show category \nExample 5: show clientvariable \nExample 6: show clientvariable clientstorename \n");
        commandExamples.put("version", "\nExample 1: version \nExample 2: v");
        commandExamples.put("which", "\nExample 1: which");
        commandExamples.put("exit", "\nExample 1: exit \nExample 2: quit\nExample 3: q");
        commandExamples.put("cls", "\nExample 1: cls \nExample 2: clear");
        commandExamples.put("export", "Example: export runtime runtime.json cfusion \n");
        commandExamples.put("import", "Example 1: import runtime runtime.json cfusion \nExample 2: import probe probe.json jee.port=8080 jee.contextroot=cfusion cfusion \n");
        commandExamples.put("delete", "Example 1: delete datasource datasourcename \nExample 2: delete jvm <string_occurence_to_be_removed_from_jvmargs> \nExample 3: delete solr language Greek  \nExample 4: delete document local \nExample 5: delete ldapconfig default \nExample 6: delete samlconfig default \nExample 7: delete clientvariable clientstorename");
    }
}

