/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.base.SettingsDictionary;
import com.adobe.cfsetup.constants.CFVersions;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SettingFactory {
    public static Map<String, SettingFactory> factories = new HashMap<String, SettingFactory>();
    private final String instancePath;
    private Map<String, GenericSetting> factoryMap = new TreeMap<String, GenericSetting>(String.CASE_INSENSITIVE_ORDER);

    public SettingFactory(String instancePath) {
        this.instancePath = instancePath;
        this.initializeSettings();
    }

    public void registerFactory(String type, GenericSetting cBase) {
        this.factoryMap.put(type.toUpperCase(), cBase);
    }

    public GenericSetting getSetting(Category category) {
        return this.factoryMap.get(category.name());
    }

    private void initializeSettings() {
        CFVersions cfVersions = RegisterInstanceImpl.getInstance().getCFVersionFromJar(this.instancePath);
        Set<Category> categories = SettingsDictionary.listSupportedCategories(cfVersions);
        categories.forEach(category -> {
            if (!Util.isCategoryDisabled(this.instancePath, category.name())) {
                this.registerFactory(category.name(), SettingInstanceProvider.getInstance().getSettingInstanceFromCFHome(this.instancePath, (Category)((Object)category), false));
            }
        });
    }
}

