/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class AbstractCommand
implements Callable {
    private CommandInfo commandInfo;
    private GenericSetting genericSetting;
    private File executionFile;
    private boolean useCachedSetting = false;
    public static CommandName commandName;
    public static boolean isLambda;

    public abstract CommandInfo parseCommand();

    public abstract boolean validateCommand();

    public abstract ExitStatus runCommand();

    public GenericSetting getGenericSetting() {
        return this.genericSetting;
    }

    public void setGenericSetting(GenericSetting genericSetting) {
        this.genericSetting = genericSetting;
    }

    public CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    public void setCommandInfo(CommandInfo commandInfo) {
        this.commandInfo = commandInfo;
    }

    public File getExecutionFile() {
        return this.executionFile;
    }

    public void setExecutionFile(File executionFile) {
        this.executionFile = executionFile;
    }

    public boolean isUseCachedSetting() {
        return this.useCachedSetting;
    }

    public void setUseCachedSetting(boolean useCachedSetting) {
        this.useCachedSetting = useCachedSetting;
    }

    public void reset() {
        this.commandInfo = null;
        this.genericSetting = null;
        this.executionFile = null;
        commandName = null;
        this.useCachedSetting = false;
    }

    public String getExecutionPathForLambda() {
        if (AbstractCommand.isLambdaMode()) {
            return AbstractCommand.getServerlessHome();
        }
        return null;
    }

    protected String getExecutionPathForLambda(List<String> command) {
        if (AbstractCommand.isLambdaMode()) {
            String executionPath = this.getExecutionPathForLambda();
            command.add(executionPath);
            return executionPath;
        }
        return null;
    }

    protected boolean isCategoryAllowed(Category category) {
        if (AbstractCommand.isLambdaMode()) {
            return category.isServerlessCompatible();
        }
        return true;
    }

    public static boolean isLambdaMode() {
        return isLambda;
    }

    private static String getServerlessHome() {
        return System.getProperty("configHome") + File.separator + ".." + File.separator + ".." + File.separator + "cfusion";
    }

    static {
        isLambda = Boolean.getBoolean("LAMBDAMODE");
    }
}

