/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.CommandLogger;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.CommandHelpRenderer;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.commands.service.AddCommandService;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.validation.SettingValidation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="add", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern: %n ")
public class AddCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="2..*", hidden=true)
    public List<String> add;
    @CommandLine.Parameters(index="0", hidden=true)
    private Category category;
    private Map<String, Object> keyValueMap;

    public Integer call() {
        AbstractCommand.commandName = CommandName.ADD;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        this.keyValueMap = new HashMap<String, Object>();
        if (!this.category.isMultiLevel() && this.category != Category.SOLR && this.category != Category.LDAPCONFIG && this.category != Category.SAMLCONFIG) {
            MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
            throw new CFSetupException(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
        }
        String executionPath = this.add.get(this.add.size() - 1).contains("=") ? this.getExecutionPathForLambda(this.add) : this.add.get(this.add.size() - 1);
        int last = this.add.size() - 1;
        int start = 1;
        String service = null;
        if (this.add.size() >= 3 && !this.add.get(1).contains("=")) {
            start = 2;
            service = this.add.get(1);
        }
        List<String> userSetting = this.add.size() <= 2 || executionPath == null ? this.add.subList(start, last + 1) : this.add.subList(start, last);
        boolean error = false;
        Set<String> toBeEncryptedFields = SettingValidation.getInstance().getEncryptedFields(this.category);
        for (String s : userSetting) {
            String[] settingPair = s.split("=");
            if (settingPair.length < 2) {
                MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
                MessageHandler.getInstance().showError(CommandHelpRenderer.getAddHelpMessage(this.category));
                throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
            }
            String settingKey = settingPair[0];
            String settingValue = Util.trimQuotes(s.substring(settingKey.length() + 1));
            String actualSetting = ProposedSetting.getInstance().getActualSetting(this.category, settingKey);
            if (actualSetting == null) {
                MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", settingKey, this.category.name()));
                error = true;
            }
            if (this.keyValueMap.get(actualSetting) != null && !SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                MessageHandler.getInstance().showError(Messages.getString("duplicateSettingkey", settingKey));
                error = true;
            }
            if (toBeEncryptedFields.contains(actualSetting) || this.category == Category.SECURITY) {
                CommandLogger.encrypt(settingKey, settingValue);
            }
            if (error) continue;
            if (SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                Util.parseUserList(this.keyValueMap, actualSetting, settingValue);
                continue;
            }
            this.keyValueMap.put(actualSetting, settingValue);
        }
        if (error) {
            throw new CFSetupException("Error while parsing");
        }
        this.keyValueMap = Collections.unmodifiableMap(this.keyValueMap);
        return CommandInfo.builder().category(this.category).executionPath(executionPath).service(service).build();
    }

    @Override
    public boolean validateCommand() {
        boolean isReqValPresnt;
        String serviceKey = SettingValidation.getInstance().getServiceKey(this.category);
        if (!super.isCategoryAllowed(this.category)) {
            MessageHandler.getInstance().showError(Messages.getString("disabledForServerless"));
            return false;
        }
        if (!Util.validateExecutionPath(this.getExecutionFile())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            return false;
        }
        if (Objects.isNull(this.getGenericSetting())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            throw new CFSetupException(Messages.getString("invalidInstance"));
        }
        SettingValidation.getInstance().dependencyValidation(this.category, this.keyValueMap, new HashMap<String, Object>());
        boolean bl = isReqValPresnt = StringUtils.isNotBlank((CharSequence)this.getCommandInfo().getService()) || SettingValidation.getInstance().validateRequiredFields(this.category, this.keyValueMap);
        if (!isReqValPresnt) {
            return false;
        }
        Optional<Map<String, Object>> optionalMap = SettingValidation.getInstance().validateCommand(this.category, this.keyValueMap);
        if (!optionalMap.isPresent()) {
            return false;
        }
        this.keyValueMap = new HashMap<String, Object>(optionalMap.get());
        if (StringUtils.isNotBlank((CharSequence)this.getCommandInfo().getService()) && !this.getGenericSetting().getMap().containsKey(this.getCommandInfo().getService())) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", this.getCommandInfo().getService(), this.category.name()));
            return false;
        }
        return (StringUtils.isNotBlank((CharSequence)this.getCommandInfo().getService()) || SettingValidation.getInstance().validateAddDuplicateServiceName(this.getGenericSetting(), this.keyValueMap)) && this.getGenericSetting().validate(this.keyValueMap, this.getCommandInfo().getService());
    }

    @Override
    public ExitStatus runCommand() {
        boolean status = AddCommandService.INSTANCE.updateService((MultilevelSetting)this.getGenericSetting(), this.keyValueMap, this.getCommandInfo().getService(), this.getExecutionFile());
        if (status) {
            MessageHandler.getInstance().showGreenAndBold(Messages.getString("addSuccess", this.category.name().toLowerCase()), true);
            return ExitStatus.SUCCESS;
        }
        MessageHandler.getInstance().showError(Messages.getString("addFail", this.category.name().toLowerCase()));
        return ExitStatus.FAIL;
    }

    public void setCategory(Category category) {
        this.category = category;
    }
}

