/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.EntryPoint;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="alias", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class AliasCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(AliasCommand.class);
    public static final String ALIAS_COMMAND = "alias";
    @CommandLine.Parameters(paramLabel="alias", arity="1..2", hidden=true)
    private List<String> args;
    @CommandLine.Option(names={"-u", "-U"}, description={"If alias already exits, it will update existing alias"})
    private boolean update;
    @CommandLine.Option(names={"-d", "-D"}, description={"It will delete existing alias"})
    private boolean delete;
    private String alias;
    private String cfHomePath;

    @Override
    public CommandInfo parseCommand() {
        if (this.update && this.delete) {
            MessageHandler.getInstance().showError(Messages.getString("ALIAS.chooseUpdateOrDelete"));
            return null;
        }
        EntryPoint.cmd.getSubcommands().entrySet().stream().filter(e -> this.delete && this.args.size() > 1 || !this.delete && this.args.size() == 1).filter(e -> ((String)e.getKey()).equalsIgnoreCase(ALIAS_COMMAND)).findFirst().ifPresent(e -> {
            MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
            if (!EntryPoint.isNonInteractive) {
                ((CommandLine)e.getValue()).usage(System.out);
            }
        });
        this.alias = this.args.get(0);
        if (!this.delete) {
            this.cfHomePath = this.args.get(1);
        }
        return CommandInfo.builder().build();
    }

    @Override
    public boolean validateCommand() {
        if (!this.delete && !Util.validCFHome(new File(this.cfHomePath))) {
            MessageHandler.getInstance().showError(Messages.getString("invalidCF"));
            return false;
        }
        if (!this.delete && !this.update && Pattern.matches(this.alias, "[a-zA-Z0-9]+")) {
            MessageHandler.getInstance().showError(Messages.getString("alphaNumericAliasOnly"));
            return false;
        }
        if ((this.delete || this.update) && RegisterInstanceImpl.getAliasFromMap(this.alias) == null) {
            MessageHandler.getInstance().showError(Messages.getString("provideValidAlias"));
            return false;
        }
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        try {
            boolean status = !this.delete ? RegisterInstanceImpl.getInstance().registerInstance(this.cfHomePath, this.alias, this.update) : RegisterInstanceImpl.getInstance().deleteAlias(this.alias);
            return status ? ExitStatus.SUCCESS : ExitStatus.FAIL;
        }
        catch (Exception e) {
            logger.error("Alias registration error : ", (Throwable)e);
            throw new CFSetupException(e.getLocalizedMessage(), e);
        }
    }

    public Integer call() {
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }
}

