/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.DeleteSupportedSettings;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.exception.ValidationException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import picocli.CommandLine;

@CommandLine.Command(name="get", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class GetCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="2..*", hidden=true)
    public List<String> commandInputs;
    private Category category;
    private String service;
    private String alias;
    private File cfHome;
    private List<String> userSettings = new ArrayList<String>();
    private Map<String, String> actualSettingToInputMap = new LinkedHashMap<String, String>();
    private final String EMPTY = "<EMPTY>";
    private String executionPath = null;

    public Integer call() {
        AbstractCommand.commandName = CommandName.GET;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        String instanceHome;
        ListOrderedSet settingKeysPositional = new ListOrderedSet();
        if (this.commandInputs.size() < 2) {
            MessageHandler.getInstance().showError(Messages.getString("invalidCommand"));
            throw new CFSetupException(Messages.getString("invalidCommand"));
        }
        String lastArg = this.commandInputs.get(this.commandInputs.size() - 1);
        if (!RegisterInstanceImpl.getInstance().isAlias(lastArg) && !Util.validCFHome(new File(lastArg)) && (instanceHome = this.getExecutionPathForLambda()) != null) {
            this.commandInputs.add(instanceHome);
        }
        Iterator<String> inputIterator = this.commandInputs.iterator();
        this.category = Category.of(inputIterator.next());
        if (this.category == Category.MAPPING) {
            MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
            throw new CFSetupException(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
        }
        String secondArgument = inputIterator.next();
        if (ProposedSetting.getInstance().getActualSetting(this.category, secondArgument) == null) {
            this.service = secondArgument;
        } else {
            settingKeysPositional.add(secondArgument);
        }
        while (inputIterator.hasNext()) {
            String nextArg = inputIterator.next();
            if (inputIterator.hasNext()) {
                settingKeysPositional.add(nextArg);
                continue;
            }
            if (ProposedSetting.getInstance().getActualSetting(this.category, nextArg) != null) {
                settingKeysPositional.add(nextArg);
                continue;
            }
            if (RegisterInstanceImpl.getInstance().isAlias(nextArg) || Util.validCFHome(new File(nextArg))) {
                this.executionPath = nextArg;
                continue;
            }
            MessageHandler.getInstance().showError(Messages.getString("GET.invalidInstanceOrSetting", nextArg));
            throw new ValidationException(Messages.getString("GET.invalidInstanceOrSetting", nextArg));
        }
        LinkedList<String> positionalList = new LinkedList<String>((Collection<String>)settingKeysPositional);
        if (CollectionUtils.isEmpty(positionalList)) {
            MessageHandler.getInstance().showError(Messages.getString("GET.noValidSettingKeyProvided"));
            throw new ValidationException(Messages.getString("GET.noValidSettingKeyProvided"));
        }
        this.userSettings = positionalList;
        return CommandInfo.builder().category(this.category).service(this.service).executionPath(this.executionPath).build();
    }

    @Override
    public boolean validateCommand() {
        if (!Util.validateExecutionPath(this.getExecutionFile())) {
            if (StringUtils.isEmpty((CharSequence)this.executionPath)) {
                MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            }
            return false;
        }
        if (Objects.isNull(this.getGenericSetting())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            throw new CFSetupException(Messages.getString("invalidInstance"));
        }
        ArrayList<String> invalidSettings = new ArrayList<String>();
        for (String userSetting : this.userSettings) {
            String actualSetting = ProposedSetting.getInstance().getActualSetting(this.category, userSetting);
            if (StringUtils.isEmpty((CharSequence)actualSetting)) {
                if (this.category != Category.SERVER || "other".equalsIgnoreCase(this.service)) {
                    invalidSettings.add(userSetting);
                    continue;
                }
                actualSetting = userSetting;
            }
            this.actualSettingToInputMap.put(actualSetting, userSetting);
        }
        List<Category> categoryWithSpecialService = Arrays.asList(Category.SOLR, Category.JVM, Category.SCHEDULETASK, Category.SECURITY, Category.SAMLCONFIG, Category.LDAPCONFIG, Category.GRAPHQLCLIENTCONFIG, Category.GRAPHQLSERVICECONFIG);
        if (!categoryWithSpecialService.contains((Object)this.category) && (this.getGenericSetting() instanceof MultilevelSetting || this.getGenericSetting() instanceof DeleteSupportedSettings) && !SettingValidation.getInstance().getServicedependentKeys(this.category, this.actualSettingToInputMap.keySet()).isEmpty()) {
            if (StringUtils.isBlank((CharSequence)this.getCommandInfo().getService())) {
                MessageHandler.getInstance().showError(Messages.getString("GET.blankServiceName", this.category.name()));
                return false;
            }
            if (!this.getGenericSetting().getMap().containsKey(this.getCommandInfo().getService())) {
                MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", this.getCommandInfo().getService(), this.category.name()));
                return false;
            }
        }
        if (CollectionUtils.isEmpty(this.userSettings)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey"));
            return false;
        }
        invalidSettings.forEach(v -> MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", v, this.category.name())));
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        GenericSetting currentGenericSetting = this.getGenericSetting();
        GenericSetting genericSetting = currentGenericSetting;
        if (Objects.isNull(genericSetting)) {
            return ExitStatus.FAIL;
        }
        if (this.actualSettingToInputMap.size() == 1) {
            String val;
            String actualSetting = this.actualSettingToInputMap.keySet().iterator().next();
            Pair<GenericSetting, String> genericSettingKeyPair = Util.getExternalDependency(currentGenericSetting.getCategory(), actualSetting, this.getExecutionFile());
            if (genericSettingKeyPair != null) {
                genericSetting = (GenericSetting)genericSettingKeyPair.getLeft();
                actualSetting = (String)genericSettingKeyPair.getRight();
            }
            if ((val = genericSetting.getSetting(actualSetting, this.getCommandInfo().getService())) != null) {
                val = this.transform(this.category, actualSetting, val);
                MessageHandler.getInstance().showInfo(StringUtils.isBlank((CharSequence)val) ? "<EMPTY>" : val);
                return ExitStatus.SUCCESS;
            }
            return ExitStatus.FAIL;
        }
        int successCount = 0;
        for (String actualSetting : this.actualSettingToInputMap.keySet()) {
            String key = this.actualSettingToInputMap.get(actualSetting);
            Pair<GenericSetting, String> genericSettingKeyPair = Util.getExternalDependency(currentGenericSetting.getCategory(), actualSetting, this.getExecutionFile());
            if (genericSettingKeyPair != null) {
                genericSetting = (GenericSetting)genericSettingKeyPair.getLeft();
                actualSetting = (String)genericSettingKeyPair.getRight();
            } else {
                genericSetting = currentGenericSetting;
            }
            String val = genericSetting.getSetting(actualSetting, this.getCommandInfo().getService());
            if ((val = this.transform(this.category, actualSetting, val)) == null) continue;
            MessageHandler.getInstance().showGreen(key + ": ", false);
            MessageHandler.getInstance().showInfo(StringUtils.isBlank((CharSequence)val) ? "<EMPTY>" : val);
            ++successCount;
        }
        if (successCount == 0) {
            return ExitStatus.FAIL;
        }
        if (successCount == this.actualSettingToInputMap.size()) {
            return ExitStatus.SUCCESS;
        }
        return ExitStatus.FAIL;
    }

    private String transform(Category category, String actualSetting, String val) {
        return SettingValidation.getInstance().transformToUserValue(category, actualSetting, val);
    }

    @Override
    public void reset() {
        super.reset();
        this.alias = null;
        this.service = null;
        this.category = null;
        this.cfHome = null;
        this.userSettings = null;
        this.executionPath = null;
        this.actualSettingToInputMap = new LinkedHashMap<String, String>();
    }

    public List<String> getUserSettings() {
        return this.userSettings;
    }
}

