/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.EntryPoint;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="help", descriptionHeading="%nDescription: ", customSynopsis={"help <category>", "help <category> <setting key>", "help <command>"}, synopsisHeading="Usage Pattern:%n", helpCommand=true)
public class HelpCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="1..2", hidden=true)
    public List<String> argList;
    @CommandLine.Parameters(index="0", hidden=true)
    private String firstArg;
    private String setting;
    private static int SPACE_LENGTH = 50;
    private static String KEY = "Key";
    private static String USER_KEY = "Setting";
    private static String TYPE = "Type";
    private static String REQUIRED = "Required";

    @Override
    public CommandInfo parseCommand() {
        Optional<Category> op = Category.getCategory(this.firstArg);
        if (op.isPresent()) {
            return CommandInfo.builder().category(op.get()).build();
        }
        return CommandInfo.builder().category(null).build();
    }

    @Override
    public boolean validateCommand() {
        boolean valid = true;
        if (this.argList.size() > 1) {
            this.setting = this.argList.get(1);
            String userDefSetting = ProposedSetting.getInstance().getActualSetting(this.getCommandInfo().getCategory(), this.setting);
            if (this.getCommandInfo().getCategory() != null) {
                boolean bl = valid = userDefSetting != null;
            }
        }
        if (!valid) {
            MessageHandler.getInstance().showError(Messages.getString("IncorrectCommandSyntax", "help"));
        }
        return valid;
    }

    @Override
    public ExitStatus runCommand() {
        if (this.getCommandInfo().getCategory() != null) {
            System.out.println("\u001b[1m" + USER_KEY + this.space(USER_KEY.length()) + REQUIRED + this.space(REQUIRED.length()) + TYPE + "\u001b[0m");
            Map<String, ValidationDetails> validationDetailsMap = SettingValidation.getInstance().getcategoryValidationMap(this.getCommandInfo().getCategory());
            if (StringUtils.isBlank((CharSequence)this.setting)) {
                Map<String, String> settingMap = ProposedSetting.getInstance().getCategoryProposedSettingMap(this.getCommandInfo().getCategory());
                settingMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).forEach(entry -> this.print(validationDetailsMap, (String)entry.getKey(), (String)entry.getValue()));
            } else {
                this.print(validationDetailsMap, ProposedSetting.getInstance().getActualSetting(this.getCommandInfo().getCategory(), this.setting), this.setting);
            }
        } else {
            String commandName = this.firstArg.toLowerCase();
            if (EntryPoint.cmd.getSubcommands().get(commandName) != null) {
                if (this.setting != null && !Category.getCategory(this.setting).isPresent()) {
                    MessageHandler.getInstance().showError(Messages.getString("HELP.invalidCommandCategory", this.setting));
                    return ExitStatus.FAIL;
                }
                if (this.setting != null && "add".equalsIgnoreCase(commandName)) {
                    ((CommandLine.Model.ArgSpec)((CommandLine)EntryPoint.cmd.getSubcommands().get(commandName)).getCommandSpec().requiredArgs().get(1)).setValue((Object)Category.getCategory(this.setting).get());
                }
                MessageHandler.getInstance().showInfo(((CommandLine)EntryPoint.cmd.getSubcommands().get(commandName)).getUsageMessage());
            } else {
                MessageHandler.getInstance().showError(Messages.getString("HELP.invalidCommandCategory", this.firstArg));
                return ExitStatus.FAIL;
            }
        }
        return ExitStatus.SUCCESS;
    }

    public Integer call() {
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    private void print(Map<String, ValidationDetails> validationDetailsMap, String actualSetting, String userkey) {
        ValidationDetails validationDetails = null;
        if (MapUtils.isNotEmpty(validationDetailsMap)) {
            validationDetails = validationDetailsMap.get(actualSetting);
        }
        if (validationDetails != null && validationDetails.isRestricted()) {
            return;
        }
        System.out.print(userkey + this.space(userkey.length()));
        String type = "string";
        boolean required = false;
        if (validationDetails != null) {
            type = StringUtils.isBlank((CharSequence)validationDetails.getType()) ? "string" : validationDetails.getType().toLowerCase();
            required = validationDetails.isRequired();
        }
        System.out.println(required + this.space(String.valueOf(required).length()) + type);
    }

    private String space(int length) {
        Object s = "";
        for (int i = 0; i < SPACE_LENGTH - length; ++i) {
            s = (String)s + " ";
        }
        return s;
    }

    @Override
    public void reset() {
        super.reset();
        this.setting = null;
    }
}

