/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.SecurityService;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class AdminLdapConfigSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> ldapConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File securityFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SECURITY.getFileName());
    private final SecurityService securityService = new SecurityService(this.securityFile, this.selectedPath);

    public AdminLdapConfigSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.securityService.getAdminLdapConfigMap());
        this.ldapConfigMap = map;
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        if (this.ldapConfigMap != null && !this.ldapConfigMap.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("alreadyAdded", "ldapconfig"));
            return false;
        }
        if (map.containsKey("credentials")) {
            Map credential = this.securityService.processLdapConfigCredentials((String)map.get("credentials"));
            if (credential == null) {
                return false;
            }
            if (((String)credential.get("userbindDN")).isEmpty()) {
                MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
                MessageHandler.getInstance().showError(Messages.getString("isEmpty", "userbindDN"));
                return false;
            }
            if (((String)credential.get("password")).isEmpty()) {
                MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
                MessageHandler.getInstance().showError(Messages.getString("isEmpty", "password"));
                return false;
            }
            String seed = this.getSeed();
            String encryptedPassword = PasswordUtils.encryptPassword((String)credential.get("password"), seed);
            map.put("credentials", (String)credential.get("userbindDN") + ";" + encryptedPassword);
        }
        this.ldapConfigMap.putAll(map);
        this.securityService.updateLdapConfig(map);
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (!service.equalsIgnoreCase("default")) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, "ldapconfig"));
            return false;
        }
        if (this.ldapConfigMap == null || this.ldapConfigMap.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("notAdded", "ldapConfig"));
            return false;
        }
        this.ldapConfigMap = null;
        this.securityService.updateLdapConfig(this.ldapConfigMap);
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.ldapConfigMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        if (AbstractCommand.commandName != CommandName.IMPORT && (this.ldapConfigMap == null || this.ldapConfigMap.isEmpty())) {
            MessageHandler.getInstance().showError(Messages.getString("cannotUseSet", "ldapconfig"));
            return false;
        }
        if (name.equalsIgnoreCase("credentials")) {
            Map newCreds = this.securityService.processLdapConfigCredentials((String)value);
            if (newCreds.size() < 2) {
                MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
                return false;
            }
            if (!this.ldapConfigMap.containsKey("credentials")) {
                if (((String)newCreds.get("userbindDN")).isEmpty()) {
                    MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
                    MessageHandler.getInstance().showError(Messages.getString("emptyField", "userbindDN"));
                    return false;
                }
                if (((String)newCreds.get("password")).isEmpty()) {
                    MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
                    MessageHandler.getInstance().showError(Messages.getString("emptyField", "password"));
                    return false;
                }
                String seed = this.getSeed();
                String encryptedPassword = PasswordUtils.encryptPassword((String)newCreds.get("password"), seed);
                value = (String)newCreds.get("userbindDN") + ";" + encryptedPassword;
            } else {
                Map oldCreds = this.securityService.processLdapConfigCredentials((String)this.ldapConfigMap.get("credentials"));
                Object finalValue = "";
                if (((String)newCreds.get("userbindDN")).isEmpty() && ((String)newCreds.get("password")).isEmpty()) {
                    MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
                    return false;
                }
                finalValue = !((String)newCreds.get("userbindDN")).isEmpty() ? (String)finalValue + (String)newCreds.get("userbindDN") + ";" : (String)finalValue + (String)oldCreds.get("userbindDN") + ";";
                if (!((String)newCreds.get("password")).isEmpty()) {
                    String seed = this.getSeed();
                    String encryptedPassword = PasswordUtils.encryptPassword((String)newCreds.get("password"), seed);
                    finalValue = (String)finalValue + encryptedPassword;
                } else {
                    finalValue = (String)finalValue + (String)oldCreds.get("password");
                }
                value = finalValue;
            }
        }
        this.ldapConfigMap.put(name, value);
        this.securityService.updateLdapConfig(this.ldapConfigMap);
        return true;
    }

    public Map getCredentials() {
        if (!this.ldapConfigMap.containsKey("credentials")) {
            return null;
        }
        return this.securityService.processLdapConfigCredentials((String)this.ldapConfigMap.get("credentials"));
    }

    @Override
    public Map<String, Object> getMap() {
        return this.ldapConfigMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.securityFile;
    }

    @Override
    public Category getCategory() {
        return Category.LDAPCONFIG;
    }
}

