/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.service.ClientVariableService;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ClientVariableSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private File clientValiablesXMLFile;
    private Map<String, Object> clientVariablesMap;
    private ClientVariableService service;
    private static final List<String> defaultClientStores = Arrays.asList("NONE", "COOKIE", "REGISTRY");
    private static final List<String> clientVariableSettings = Arrays.asList("default", "uuidToken", "PURGE_INTERVAL");

    public ClientVariableSettings(String instancePath) {
        super(instancePath);
        this.clientValiablesXMLFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.CLIENTVARIABLE.getFileName());
        this.service = new ClientVariableService(this.clientValiablesXMLFile);
        this.populateMap();
    }

    @Override
    public void populateMap() {
        this.clientVariablesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.clientVariablesMap.putAll(this.service.getClientVariables());
    }

    private Map getClientStoresMap(Map map) {
        TreeMap clientStores = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        map.forEach((key, value) -> {
            if (!clientVariableSettings.contains(key)) {
                clientStores.put((String)key, value);
            }
        });
        return clientStores;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{service}) && !this.clientVariablesMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.invalidClientVariableOption"));
            return false;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}) && "default".equalsIgnoreCase(name) && value instanceof String && !this.isClientStorageValid((String)value)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.invalidClientStoreValue"));
            return false;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{service}) && this.clientVariablesMap.containsKey(service)) {
            Map clientSettingMap = (Map)this.clientVariablesMap.get(service);
            clientSettingMap.put(name, value);
        } else {
            this.clientVariablesMap.put(name, value);
        }
        return this.saveModifiedMap();
    }

    private boolean isClientStorageValid(String value) {
        if (value.isEmpty()) {
            return true;
        }
        for (String validValue : this.getClientStores()) {
            if (!validValue.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private boolean saveModifiedMap() {
        return this.service.saveModifiedMap(this.clientVariablesMap);
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{service}) && !this.clientVariablesMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.invalidClientVariableOption"));
            return null;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{service})) {
            Map clientSettingMap = (Map)this.clientVariablesMap.get(service);
            if (!clientSettingMap.containsKey(name)) {
                MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
                return null;
            }
            return clientSettingMap.get(name).toString();
        }
        if (!this.clientVariablesMap.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return String.valueOf(this.clientVariablesMap.get(name));
    }

    @Override
    public boolean validate(Map<String, Object> keyValue, String service) {
        String name = (String)keyValue.get("name");
        if (AbstractCommand.commandName == CommandName.SET && name != null && defaultClientStores.contains(service.toUpperCase())) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotRenameDefaultClientStores"));
            return false;
        }
        if (AbstractCommand.commandName == CommandName.SET && name != null && ((Map)this.getClientStoresMap(this.clientVariablesMap).get(service)).get("type").toString().equalsIgnoreCase("JDBC")) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotRenameJDBCClientStores"));
            return false;
        }
        if (AbstractCommand.commandName == CommandName.ADD && name != null && defaultClientStores.contains(name.toUpperCase())) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotAddDefaultClientStores"));
            return false;
        }
        if (AbstractCommand.commandName == CommandName.ADD && !this.isDatasourceNameValid(name)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.canOnlyAddDatasourceAsClientStore"));
            return false;
        }
        if (AbstractCommand.commandName == CommandName.ADD && this.getClientStores().contains(name)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotAddDatasourceAsClientStoreAlreadyExists", name));
            return false;
        }
        return true;
    }

    @Override
    public void show(String service) {
        TreeMap<String, Object> internalMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        internalMap.putAll(this.getInternalMap());
        this.putDependentSettings(internalMap);
        Map<String, Object> map = this.sortMap(internalMap, 0);
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)"Clientstore".concat(this.showSuffix())), true);
            if (MapUtils.isEmpty(map)) {
                MessageHandler.getInstance().showInfo("\t" + Messages.getString("NoSettingsFound"));
                return;
            }
            map.forEach((sname, value) -> {
                if (value instanceof Map) {
                    if ("*".equals(service) || !(this instanceof MultilevelSetting)) {
                        MessageHandler.getInstance().showBlueAndBold("\t" + sname + ":", true);
                        this.printMap((Map)value, "\t");
                    } else {
                        MessageHandler.getInstance().showInfo((String)sname);
                    }
                }
            });
            MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)this.getCategory().name().toLowerCase().concat(" Settings:")), true);
            if (MapUtils.isEmpty(map)) {
                MessageHandler.getInstance().showInfo("\t" + Messages.getString("NoSettingsFound"));
                return;
            }
            map.forEach((sname, value) -> {
                String userDefinedName;
                if (!(value instanceof Map || value instanceof Collection || Objects.isNull(userDefinedName = sname))) {
                    String stringValue;
                    if (value instanceof MapObject) {
                        MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                        stringValue = ((MapObject)value).getValue();
                    } else {
                        MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                        stringValue = String.valueOf(value);
                    }
                    String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                    stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                    MessageHandler.getInstance().showInfo(stringValue);
                }
            });
            return;
        }
        if (!internalMap.containsKey(service)) {
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        Object value2 = map.get(service);
        if (value2 instanceof Map) {
            MessageHandler.getInstance().showGreenAndBold(service + ":", true);
            this.printMap((Map)value2, "");
        } else if (value2 instanceof Collection) {
            MessageHandler.getInstance().showGreen(service + ":", true);
            this.printCollection((Collection)value2, "");
        } else {
            String userDefinedName = service;
            if (!Objects.isNull(userDefinedName)) {
                String stringValue = value2 instanceof MapObject ? ((MapObject)value2).getValue() : String.valueOf(value2);
                String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                MessageHandler.getInstance().showInfo(stringValue);
            }
        }
    }

    @Override
    public boolean addService(Object val) {
        try {
            ConfigMap map = new ConfigMap((Map)val);
            String name = (String)map.get("name");
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                map = this.hydrateMapWithDefaultFields(map);
            }
            this.clientVariablesMap.put(name, map);
            this.saveModifiedMap();
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            return false;
        }
        return true;
    }

    private ConfigMap hydrateMapWithDefaultFields(ConfigMap map) {
        ConfigMap defaultMap = new ConfigMap();
        defaultMap.put("name", map.get("name"));
        defaultMap.put("type", "JDBC");
        defaultMap.put("dsn", map.get("name"));
        defaultMap.put("purge", (Object)true);
        defaultMap.put("timeout", map.getOrDefault("timeout", 90));
        defaultMap.put("description", map.getOrDefault("description", ""));
        defaultMap.put("disable_globals", map.getOrDefault("disable_globals", false));
        return defaultMap;
    }

    @Override
    public Map<String, ?> getInternalMap() {
        return super.getInternalMap();
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        String string = service = ProposedSetting.getInstance().getActualSetting(this.getCategory(), service) != null ? ProposedSetting.getInstance().getActualSetting(this.getCategory(), service) : service;
        if (!this.clientVariablesMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        if (clientVariableSettings.contains(service)) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotDeleteDefaultClientVariableSettings", service, this.getCategory().name()));
            return false;
        }
        if (defaultClientStores.contains(service.toUpperCase())) {
            MessageHandler.getInstance().showError(Messages.getString("CLIENTVARIABLE.cannotDeleteDefaultClientStores"));
            return false;
        }
        try {
            Map clientStore;
            if (this.clientVariablesMap.containsKey(service) && this.clientVariablesMap.get(service) instanceof Map && (clientStore = (Map)this.clientVariablesMap.get(service)).containsKey("type") && clientStore.get("type").toString().equalsIgnoreCase("jdbc")) {
                if (this.clientVariablesMap.containsKey("default") && this.clientVariablesMap.get("default").toString().equalsIgnoreCase(service)) {
                    this.clientVariablesMap.put("default", "");
                }
                this.clientVariablesMap.remove(service);
                return this.saveModifiedMap();
            }
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return false;
    }

    @Override
    public File getXMLFileObject() {
        return this.clientValiablesXMLFile;
    }

    @Override
    public Category getCategory() {
        return Category.CLIENTVARIABLE;
    }

    @Override
    public Map<String, ?> getMap() {
        return this.service.getClientVariables();
    }

    private Set<String> getClientStores() {
        return this.getClientStoresMap(this.clientVariablesMap).keySet();
    }

    private boolean isDatasourceNameValid(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        DatasourceSettings datasourceSettings = new DatasourceSettings(this.selectedPath);
        return datasourceSettings.getMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(name)).findFirst().isPresent();
    }
}

