/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.DebugService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class DebugSettings
extends MultiConfigurationBase {
    private final String debugConfigXml = Category.DEBUG.getFileName();
    private Map<String, Object> debugConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File debugConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.debugConfigXml);
    private final DebugService debugService = new DebugService(this.debugConfigXmlFile);

    public DebugSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.debugConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public void populateMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.debugService.getMap());
        this.debugConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        Object object;
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
        }
        if (Objects.isNull(object = this.debugConfigMap.get(name))) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.debugConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.DEBUG;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        this.debugConfigMap.put(name, value);
        this.debugService.storeModifiedMap(this.debugConfigMap, "developer_enabled".equalsIgnoreCase(name));
        return true;
    }
}

