/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.GraphQLServiceConfigService;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GraphQLServiceSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Map<String, Object>> serviceSettingsMap;
    private final File serviceSettingsFile;
    private GraphQLServiceConfigService gqlServiceConfigService;
    Map<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public GraphQLServiceSettings(String instancePath) {
        super(instancePath);
        this.serviceSettingsMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.serviceSettingsFile = new File(this.selectedPath + File.separator + "gql" + File.separator + Category.GRAPHQLSERVICECONFIG.getFileName());
        this.gqlServiceConfigService = new GraphQLServiceConfigService(this.serviceSettingsFile);
        try {
            PasswordUtils.getInstance(instancePath);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.populateMap();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("service_name")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        this.checkServiceExists(service);
        try {
            Map settings = this.serviceSettingsMap.get(service);
            String[] order = name.split("/");
            Map settingMap = settings;
            for (int i = 0; i < order.length - 1; ++i) {
                Object settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = (Map)settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put((String)settingKey, (Object)value);
            this.gqlServiceConfigService.updateServiceConfig(service, settings);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object value = Util.getSettingValue(name, service, this.serviceSettingsMap);
        if (Objects.nonNull(value)) {
            if ("headers".equals(name)) {
                HashMap<String, Object> headersStruct = new HashMap<String, Object>();
                headersStruct.put("headers", value);
                this.gqlServiceConfigService.decryptField(headersStruct, PasswordUtils.getInstance().getSeedValue());
                return String.valueOf(headersStruct.get("headers"));
            }
            return String.valueOf(value);
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.serviceSettingsFile;
    }

    @Override
    public Category getCategory() {
        return Category.GRAPHQLSERVICECONFIG;
    }

    @Override
    public Map<String, ?> getMap() {
        return this.flatMap;
    }

    private void checkServiceExists(String service) {
        if (!this.serviceSettingsMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
    }

    @Override
    public void show(String service) {
        TreeMap<String, Object> internalMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        internalMap.putAll(this.getInternalMap());
        this.putDependentSettings(internalMap);
        Map<String, Object> map = this.sortMap(internalMap, 0);
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)this.getCategory().name().toLowerCase().concat(this.showSuffix())), true);
            if (MapUtils.isEmpty(map)) {
                MessageHandler.getInstance().showInfo("\t" + Messages.getString("NoSettingsFound"));
                return;
            }
            map.forEach((sname, value) -> {
                if (value instanceof Map) {
                    this.gqlServiceConfigService.decryptField((Map)value, PasswordUtils.getInstance().getSeedValue());
                    if ("*".equals(service) || !(this instanceof MultilevelSetting)) {
                        MessageHandler.getInstance().showBlueAndBold("\t" + sname + ":", true);
                        this.printMap((Map)value, "\t");
                    } else {
                        MessageHandler.getInstance().showInfo((String)sname);
                    }
                } else if (value instanceof Collection) {
                    MessageHandler.getInstance().showGreen("\t" + sname + " : ", true);
                    this.printCollection((Collection)value, "\t\t");
                } else {
                    String userDefinedName = sname;
                    if (!Objects.isNull(userDefinedName)) {
                        String stringValue;
                        if (value instanceof MapObject) {
                            MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                            stringValue = ((MapObject)value).getValue();
                        } else {
                            MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                            stringValue = String.valueOf(value);
                        }
                        String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                        stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                        MessageHandler.getInstance().showInfo(stringValue);
                    }
                }
            });
            return;
        }
        if (!internalMap.containsKey(service)) {
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        Object value2 = map.get(service);
        if (value2 instanceof Map) {
            this.gqlServiceConfigService.decryptField((Map)value2, PasswordUtils.getInstance().getSeedValue());
            MessageHandler.getInstance().showGreenAndBold(service + ":", true);
            this.printMap((Map)value2, "");
        } else if (value2 instanceof Collection) {
            MessageHandler.getInstance().showGreen(service + ":", true);
            this.printCollection((Collection)value2, "");
        } else {
            String userDefinedName = service;
            if (!Objects.isNull(userDefinedName)) {
                String stringValue = value2 instanceof MapObject ? ((MapObject)value2).getValue() : String.valueOf(value2);
                String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                MessageHandler.getInstance().showInfo(stringValue);
            }
        }
    }

    @Override
    public void populateMap() {
        this.serviceSettingsMap.putAll(new HashMap(this.gqlServiceConfigService.getMap()));
        this.flatMap = Util.createFlatMap(this.getCategory(), this.serviceSettingsMap);
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        this.checkServiceExists(service);
        try {
            this.gqlServiceConfigService.deleteServiceConfig(service);
            this.serviceSettingsMap.remove(service);
        }
        catch (ServiceException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean addService(Object val) {
        Map<String, Object> map = (Map<String, Object>)val;
        map = Util.expandNestedFields(map);
        String name = (String)map.get("service_name");
        try {
            this.gqlServiceConfigService.addService(name, map);
            this.serviceSettingsMap.put(name, map);
            this.populateMap();
            return true;
        }
        catch (ServiceException e) {
            return false;
        }
    }
}

