/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.LoggingService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class LoggingSettings
extends MultiConfigurationBase {
    private final String loggingConfigXml = Category.LOGGING.getFileName();
    private Map<String, Object> loggingConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File loggingConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.loggingConfigXml);
    private final LoggingService loggingService = new LoggingService(this.loggingConfigXmlFile);

    public LoggingSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.loggingConfigMap.forEach(map::put);
        if (CommandName.EXPORT.equals((Object)AbstractCommand.commandName)) {
            map.remove("logDirectory");
        }
        return map;
    }

    public Map<String, Object> getInternalMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Double maxFilesize = (Double)this.loggingConfigMap.get("maxFileSize");
        String logDirectory = (String)this.loggingConfigMap.get("logDirectory");
        this.loggingConfigMap.forEach(map::put);
        map.put("maxFileSize", maxFilesize / 1000.0);
        if (StringUtils.isEmpty((CharSequence)logDirectory)) {
            map.put("logDirectory", this.selectedPath + File.separator + "logs");
        }
        return map;
    }

    @Override
    public void populateMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.loggingService.getMap());
        this.loggingConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        Object v = this.loggingConfigMap.get(name);
        if ("maxFileSize".equalsIgnoreCase(name)) {
            v = (Double)v / 1000.0;
        }
        if (Objects.isNull(v)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return v.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        if ("maxFileSize".equalsIgnoreCase(name) && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            value = Double.valueOf(value.toString()) * 1000.0;
        }
        this.loggingConfigMap.put(name, value);
        this.loggingService.storeModifiedMap(this.loggingConfigMap);
        return true;
    }

    @Override
    public File getXMLFileObject() {
        return this.loggingConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.LOGGING;
    }
}

