/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.NoSQLService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSqlSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(NoSqlSettings.class);
    private static final String NAME = "name";
    private File noSqlXmlFile;
    private NoSQLService service;
    private Map<String, Object> nosqlMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public NoSqlSettings(String instancePath) {
        super(instancePath);
        this.noSqlXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.NOSQL.getFileName());
        this.service = new NoSQLService(this.noSqlXmlFile, this.noSqlXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        return this.nosqlMap;
    }

    @Override
    public void populateMap() {
        this.service.getDatasources().forEach((dsname, details) -> {
            HashMap dsDetails = new HashMap();
            dsDetails.putAll((Map)details);
            this.nosqlMap.put(String.valueOf(dsname), dsDetails);
        });
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            System.out.println("Please Provide Valid Datasource");
        }
        if (!this.nosqlMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return null;
        }
        Map dsDetails = (Map)this.nosqlMap.get(service);
        if (!dsDetails.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return dsDetails.get(name).toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.noSqlXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.NOSQL;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            System.out.println("Please Provide Datasource");
        }
        if (!this.nosqlMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        return this.updateMap(name, value, service);
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        if (this.service.validateDataSource(map)) {
            if ("none".equalsIgnoreCase((String)map.get("authMechanism"))) {
                map.remove("authMechanism");
            }
            this.nosqlMap.put((String)map.get(NAME), map);
            return this.saveModifiedMap();
        }
        return false;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("Invalid Nosql datasource"));
        }
        if (!this.nosqlMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        this.nosqlMap.remove(service);
        return this.saveModifiedMap();
    }

    private boolean updateMap(String name, Object newValue, String service) {
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.nosqlMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        Map datascource = (Map)this.nosqlMap.get(service);
        if (this.service.validateDataSource(datascource)) {
            if (!name.equalsIgnoreCase("authMechanism") || !"NONE".equalsIgnoreCase((String)datascource.get("authMechanism"))) {
                datascource.put(name, newValue);
            }
            return this.saveModifiedMap();
        }
        return true;
    }

    private boolean saveModifiedMap() {
        ConfigMap configMap = new ConfigMap();
        this.nosqlMap.forEach((key, value) -> {
            ConfigMap dsdetail = new ConfigMap();
            dsdetail.putAll((Map)value);
            configMap.put(key, dsdetail);
        });
        return this.service.saveDatasource(configMap);
    }
}

