/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.runtime.Struct;
import coldfusion.scheduling.ScheduleTagData;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.CronSettings;
import com.adobe.cfsetup.settings.ServerSetting;
import com.adobe.cfsetup.settings.service.ProbeService;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ProbeSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final String NAME = "name";
    private final String probeXml = Category.PROBE.getFileName();
    private Map<String, Object> probeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File probeXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.probeXml);
    private final ProbeService probeService = new ProbeService(this.probeXmlFile);
    private final CronSettings cronSettings = new CronSettings(this.selectedPath);

    public ProbeSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.probeMap.forEach(map::put);
        map.forEach((k, v) -> ((Map)v).put(NAME, k));
        return map;
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.probeService.getProbesMap());
        this.probeMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Map v = (Map)this.probeMap.get(service);
        if (Objects.isNull(v)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name()));
        }
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.probeXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.PROBE;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        Map map = (Map)this.probeMap.get(service);
        if (map != null) {
            map.put(name, value);
            if (!this.validateProbe(map)) {
                return false;
            }
        } else {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name()));
        }
        this.probeService.storeModifiedProbe(this.probeMap);
        this.cronSettings.addService(this.getCronObjectFromProbe(service, this.probeMap));
        return true;
    }

    @Override
    public boolean addService(Object val) {
        final Struct map = new Struct();
        map.putAll((Map)val);
        final String name = (String)map.get(NAME);
        map.remove(NAME);
        if (!this.validateProbe(map)) {
            return false;
        }
        this.probeMap.putAll(new Struct(){
            {
                this.put(name, map);
            }
        });
        this.probeService.storeModifiedProbe(this.probeMap);
        this.cronSettings.addService(this.getCronObjectFromProbe(name, this.probeMap));
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (this.probeMap.get(service) == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name().toLowerCase()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.PROBE.name().toLowerCase()));
        }
        this.probeMap.remove(service);
        this.probeService.storeModifiedProbe(this.probeMap);
        this.cronSettings.deleteService("CFPROBE___".toLowerCase() + service + ":default:server");
        return true;
    }

    private ScheduleTagData getCronObjectFromProbe(String probeName, Map probeMap) {
        ScheduleTagData scheduleTagData = ScheduleTagData.defaultMap();
        probeMap = (Map)probeMap.get(probeName);
        scheduleTagData.put("path", probeMap.get("PATH"));
        scheduleTagData.put("start_time", probeMap.get("START_TIME").toString().toUpperCase());
        scheduleTagData.put("task", "CFPROBE___".toLowerCase() + probeName);
        scheduleTagData.put("interval", Util.removeTrailingZeroesAfterDecimal(String.valueOf(probeMap.get("INTERVAL"))));
        scheduleTagData.put("end_time", probeMap.get("END_TIME").toString().toUpperCase());
        scheduleTagData.put("file", probeMap.get("FILE"));
        scheduleTagData.put("resolve_url", probeMap.get("RESOLVEURL"));
        scheduleTagData.put("publish", probeMap.get("PUBLISH").equals("1"));
        Map probeConfig = this.probeService.getConfigMap();
        scheduleTagData.put("username", probeConfig.get("probeUsername"));
        scheduleTagData.put("password", probeConfig.get("PROBEPASSWORD") == null ? "" : probeConfig.get("PROBEPASSWORD"));
        scheduleTagData.put("url", this.getProbeURL(probeName, probeConfig));
        return scheduleTagData;
    }

    private String getProbeURL(String probeName, Map probeConfig) {
        String probeURL = (String)probeConfig.get("probeURL");
        return (StringUtils.isNotBlank((CharSequence)probeURL) ? probeURL : this.getDefaultProbeURL()) + "?name=" + probeName;
    }

    private String getDefaultProbeURL() {
        Map<String, Object> importSettingsMap;
        String jeePort = "{JEE_PORT}";
        String jeeContextRoot = "{JEE_CONTEXTROOT}";
        boolean isJEEDeployment = Util.isJEEDeployment(this.selectedPath);
        if (isJEEDeployment && (importSettingsMap = Util.getImportSettingsMap()) != null && !importSettingsMap.isEmpty()) {
            if (importSettingsMap.containsKey("jee.port")) {
                jeePort = importSettingsMap.get("jee.port").toString();
            }
            if (importSettingsMap.containsKey("jee.contextroot")) {
                jeeContextRoot = importSettingsMap.get("jee.contextroot").toString();
            }
        }
        StringBuilder defaultURL = new StringBuilder().append("http://127.0.0.1:").append((String)(isJEEDeployment ? jeePort + "/" + jeeContextRoot : this.getConnectorPort())).append("/CFIDE/probe.cfm");
        return defaultURL.toString();
    }

    private String getConnectorPort() {
        String port = "";
        ServerSetting serverSetting = new ServerSetting(this.selectedPath);
        Map connectorMap = (Map)serverSetting.getMap().get("http");
        if (connectorMap.containsKey("port")) {
            port = connectorMap.get("port").toString();
        }
        if (StringUtils.isEmpty((CharSequence)port) && (connectorMap = (Map)serverSetting.getMap().get("https")).containsKey("port")) {
            port = connectorMap.get("port").toString();
        }
        return port;
    }

    private boolean validateProbe(Map map) {
        int v;
        int i;
        String endTime = map.get("END_TIME").toString();
        String startTime = map.get("START_TIME").toString();
        if (StringUtils.isEmpty((CharSequence)endTime)) {
            return true;
        }
        String[] end = endTime.split(" ");
        String[] start = startTime.split(" ");
        boolean isValid = true;
        if ("PM".equalsIgnoreCase(end[1]) && "AM".equalsIgnoreCase(start[1])) {
            return true;
        }
        if ("AM".equalsIgnoreCase(end[1]) && "PM".equalsIgnoreCase(start[1])) {
            isValid = false;
        }
        String[] endVals = end[0].split(":");
        String[] startVals = start[0].split(":");
        long endVal = 0L;
        long startVal = 0L;
        long multiplier = 3600L;
        for (i = 0; i < endVals.length; ++i) {
            v = Integer.valueOf(endVals[i]);
            if (i == 0 && v == 12) {
                v = 0;
            }
            endVal += (long)v * multiplier;
            multiplier /= 60L;
        }
        multiplier = 3600L;
        for (i = 0; i < startVals.length; ++i) {
            v = Integer.valueOf(startVals[i]);
            if (i == 0 && v == 12) {
                v = 0;
            }
            startVal += (long)v * multiplier;
            multiplier /= 60L;
        }
        if (endVal < startVal || !isValid) {
            MessageHandler.getInstance().showError(Messages.getString("invalidEndTime"));
            return false;
        }
        return true;
    }
}

