/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.ValidationException;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeSettings
extends MultiConfigurationBase {
    private File runtimeXmlFile;
    private Map<String, Map<String, Object>> runtimeMap = new HashMap<String, Map<String, Object>>();
    private static final Logger logger = LoggerFactory.getLogger(RuntimeSettings.class);
    private RuntimeService service;

    public RuntimeSettings(String instancePath) {
        super(instancePath);
        this.runtimeXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.RUNTIME.getFileName());
        this.service = new RuntimeService(this.runtimeXmlFile, this.runtimeXmlFile.getAbsoluteFile().getParentFile().getParent());
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> showMap = new HashMap<String, Object>();
        String setting = "";
        this.runtimeMap.forEach((name, nmap) -> {
            String los = setting + name;
            nmap.forEach((key, value) -> {
                if (value instanceof Map) {
                    RuntimeSettings.addMapToShow((Map)value, showMap, los + "/" + key);
                } else if (value instanceof String) {
                    if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                        showMap.put(los + "/" + key, value);
                    }
                } else if (Objects.nonNull(value)) {
                    showMap.put(los + "/" + key, value);
                }
            });
        });
        return showMap;
    }

    static void addMapToShow(Map<String, Object> map, Map<String, Object> showMap, String los) {
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                RuntimeSettings.addMapToShow((Map)value, showMap, los + "/" + key);
            } else {
                showMap.put(los + "/" + key, value);
            }
        });
    }

    @Override
    public void populateMap() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.putAll(this.service.getRuntimeSetting());
        this.runtimeMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        String[] str = name.split("/");
        Map settingMap = this.runtimeMap;
        for (int i = 0; i < str.length - 1; ++i) {
            Map map = settingMap.getOrDefault(str[i], new HashMap());
            if (i == str.length - 2) {
                return String.valueOf(map.get(str[str.length - 1]));
            }
            settingMap = map;
        }
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.runtimeXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.RUNTIME;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        name = this.replaceKey(name);
        String[] str = name.split("/");
        Map settingMap = this.runtimeMap;
        for (int i = 0; i < str.length - 1; ++i) {
            Map map = settingMap.getOrDefault(str[i], new HashMap());
            if (i == str.length - 2) {
                map.put(str[str.length - 1], value);
                continue;
            }
            settingMap = map;
        }
        return this.service.saveModifiedRuntimeMap(this.runtimeMap);
    }

    @Override
    public boolean validate(Map<String, Object> keyValue, String service) {
        if (keyValue.containsKey("errors/queue_timeout")) {
            String queueTimeoutPage = String.valueOf(keyValue.get("errors/queue_timeout")).trim();
            if (StringUtils.isEmpty((CharSequence)queueTimeoutPage)) {
                return true;
            }
            File queueTimeoutPageFile = new File(this.runtimeXmlFile.getParentFile().getParent() + File.separator + "wwwroot" + File.separator + queueTimeoutPage);
            if (!this.isHtmlExtension(queueTimeoutPage)) {
                MessageHandler.getInstance().showError(Messages.getString("RUNTIME.invalidQueueTimeoutPageExtension"));
                throw new ValidationException(Messages.getString("RUNTIME.invalidQueueTimeoutPageExtension"));
            }
            if (!queueTimeoutPageFile.exists() || !queueTimeoutPageFile.isFile()) {
                MessageHandler.getInstance().showError(Messages.getString("RUNTIME.invalidQueueTimeoutPage"));
                throw new ValidationException(Messages.getString("RUNTIME.invalidQueueTimeoutPage"));
            }
        }
        return true;
    }

    private boolean isHtmlExtension(String queueTimeoutPage) {
        return queueTimeoutPage.endsWith(".html") || queueTimeoutPage.endsWith(".htm");
    }

    private String replaceKey(String key) {
        return key.replaceFirst("corePoolSizeAzureServiceBus", "corePoolSizeCloudServices").replaceFirst("maxPoolSizeAzureServiceBus", "maxPoolSizeCloudServices").replaceFirst("keepAliveTimeAzureServiceBus", "keepAliveTimeCloudServices");
    }
}

