/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.service.SecurityService;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> sandboxConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File securityFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SECURITY.getFileName());
    private final SecurityService securityService = new SecurityService(this.securityFile, this.selectedPath);
    private static final Logger logger = LoggerFactory.getLogger(SandboxSettings.class);
    public static HashMap<String, String> oppositeKeysMap;
    public static Set<String> disallowedKeys;

    public SandboxSettings(String instancePath) {
        super(instancePath);
        oppositeKeysMap = new HashMap();
        oppositeKeysMap.put("enabledTags", "coldfusion.tagext.GenericTagPermission");
        oppositeKeysMap.put("coldfusion.tagext.GenericTagPermission", "enabledTags");
        oppositeKeysMap.put("enabledFunctions", "coldfusion.runtime.FunctionPermission");
        oppositeKeysMap.put("coldfusion.runtime.FunctionPermission", "enabledFunctions");
        oppositeKeysMap.put("coldfusion.sql.DataSourcePermission", "disabledDatasources");
        oppositeKeysMap.put("disabledDatasources", "coldfusion.sql.DataSourcePermission");
        oppositeKeysMap.put("java.lang.RuntimePermission", "disabledRuntimePermissions");
        oppositeKeysMap.put("disabledRuntimePermissions", "java.lang.RuntimePermission");
        disallowedKeys = new HashSet<String>();
        disallowedKeys.add("enabledTags");
        disallowedKeys.add("enabledFunctions");
        disallowedKeys.add("disabledDatasources");
        disallowedKeys.add("java.lang.RuntimePermission");
        this.populateMap();
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.securityService.getSandboxMap());
        this.sandboxConfigMap = map;
    }

    @Override
    public boolean addService(Object val) {
        return this.addService((Map)val, null);
    }

    @Override
    public boolean addService(Map keyValueMap, String service) {
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER){
            {
                this.putAll(SandboxSettings.this.sandboxConfigMap);
            }
        };
        if (service != null) {
            service = Util.addFileSeparator(service);
        }
        String directory = service;
        if (AbstractCommand.commandName == CommandName.IMPORT) {
            Util.updateListToSet(keyValueMap);
        }
        Map sandboxMap = Util.getSandboxMap(map, directory);
        if (!StringUtils.isBlank((String)directory) && sandboxMap != null) {
            keyValueMap.remove("directory");
            keyValueMap = this.processSettingsOfMap(keyValueMap, sandboxMap, directory);
            if (keyValueMap == null) {
                return false;
            }
        } else {
            Set<CallSite> filePerms;
            directory = (String)keyValueMap.get("directory");
            directory = Util.addFileSeparator(directory);
            Set<String> dirSet = this.sandboxConfigMap.keySet();
            File f = new File(directory);
            for (String dir : dirSet) {
                File dirF = new File(dir);
                if (!f.equals(dirF)) continue;
                MessageHandler.getInstance().showError(Messages.getString("duplicateServiceKey", this.getCategory().name(), ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "directory"), directory));
                return false;
            }
            Set set = filePerms = keyValueMap.containsKey("java.io.FilePermission") ? (Set)keyValueMap.get("java.io.FilePermission") : new HashSet();
            if (AbstractCommand.commandName != CommandName.IMPORT) {
                filePerms.add((CallSite)((Object)("read,write,delete:" + directory)));
                filePerms.add((CallSite)((Object)("read,write,delete:" + directory + "-")));
            }
            keyValueMap.remove("directory");
            keyValueMap = this.processSettingsOfMap(keyValueMap, this.getDefaultPermissions(Util.addFileSeparator(directory)), directory);
            if (keyValueMap == null) {
                return false;
            }
            map.put(directory, keyValueMap);
        }
        this.securityService.updateSandboxData(map, this.selectedPath, this.isAdminPath(directory));
        this.sandboxConfigMap = map;
        this.showJeeConfigurationMessage();
        return true;
    }

    private Map getDefaultPermissions(String directory) {
        HashMap map = new HashMap();
        HashSet<Object> set = new HashSet<Object>();
        set.add("*");
        map.put("java.io.SerializablePermission", set);
        map.put("java.net.NetPermission", set);
        map.put("java.sql.SQLPermission", set);
        map.put("java.security.SecurityPermission", set);
        map.put("java.lang.reflect.ReflectPermission", set);
        map.put("coldfusion.tagext.GenericTagPermission", new HashSet());
        map.put("coldfusion.tagext.lang.ModulePermission", set);
        set = new HashSet();
        set.add("read,write;*");
        map.put("java.util.PropertyPermission", set);
        set = new HashSet();
        set.add("connect,resolve;*");
        map.put("java.net.SocketPermission", set);
        set = new HashSet();
        set.add("createobject(java)");
        map.put("coldfusion.runtime.FunctionPermission", set);
        set = new HashSet();
        set.addAll(SecurityService.allRuntimePerms);
        map.put("java.lang.RuntimePermission", set);
        set = new HashSet();
        set.add("read,write,delete:" + directory);
        set.add("read,write,delete:" + directory + "-");
        map.put("java.io.FilePermission", set);
        return map;
    }

    @Override
    public boolean deleteService(String service) {
        service = Util.addFileSeparator(service);
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.sandboxConfigMap);
        if (this.isAdminPath(service)) {
            MessageHandler.getInstance().showError(Messages.getString("canNotDeleteRestrictedSandbox"));
            return false;
        }
        map.remove(service);
        this.securityService.updateSandboxData(map, this.selectedPath, this.isAdminPath(this.selectedPath));
        this.sandboxConfigMap = map;
        return true;
    }

    @Override
    public boolean deleteService(Map<String, List> keyValueMap, String service) {
        if (MapUtils.isEmpty(keyValueMap)) {
            return this.deleteService(service);
        }
        TreeMap<String, Object> sandboxMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        sandboxMap.putAll(this.sandboxConfigMap);
        Map map = Util.getSandboxMap(sandboxMap, service);
        HashSet<String> disallowedSet = new HashSet<String>();
        Iterator<Map.Entry<String, List>> iterator = keyValueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List> o;
            Map.Entry<String, List> entry = o = iterator.next();
            List v = entry.getValue();
            String k = entry.getKey();
            if (!disallowedKeys.contains(k) || v.size() <= 0) continue;
            disallowedSet.add(k);
        }
        if (disallowedSet.size() > 0) {
            MessageHandler.getInstance().showError(Messages.getString("keyDisabled", StringUtils.join(disallowedSet, (String)",").toUpperCase(), AbstractCommand.commandName.toString(), this.getCategory().toString()));
            return false;
        }
        for (Map.Entry<String, List> entry : keyValueMap.entrySet()) {
            String key = entry.getKey();
            if ("java.io.FilePermission".equalsIgnoreCase(entry.getKey()) || "java.net.SocketPermission".equalsIgnoreCase(entry.getKey())) {
                HashSet<String> newFiles = new HashSet<String>();
                Iterator newFilesIterator = keyValueMap.get(key).iterator();
                if (keyValueMap.get(key).contains("")) {
                    map.put(key, new HashSet());
                    continue;
                }
                while (newFilesIterator.hasNext()) {
                    String file = (String)newFilesIterator.next();
                    file = file.substring(file.indexOf(":") + 1);
                    newFiles.add(file);
                }
                Set existingSet = (Set)map.get(key);
                Iterator it = existingSet.iterator();
                int size = existingSet.size();
                HashSet<String> notPresentSet = new HashSet<String>();
                for (String fileToBeDeleted : newFiles) {
                    boolean isPresent = false;
                    for (String existingFile : existingSet) {
                        if (!existingFile.substring(existingFile.indexOf(":") + 1).equalsIgnoreCase(fileToBeDeleted)) continue;
                        isPresent = true;
                        break;
                    }
                    if (isPresent) continue;
                    notPresentSet.add(fileToBeDeleted);
                }
                if (notPresentSet.size() > 0) {
                    MessageHandler.getInstance().showError(Messages.getString("errorDeletingGivenValues", StringUtils.join(notPresentSet, (String)","), ProposedSetting.getInstance().getUserDefinedValue(Category.SANDBOX, key)));
                    return false;
                }
                while (it.hasNext()) {
                    String file = (String)it.next();
                    if (!newFiles.contains(file = file.substring(file.indexOf(":") + 1))) continue;
                    if (key.equalsIgnoreCase("java.io.FilePermission")) {
                        if (SecurityService.isRestrictedPath(file) && this.isAdminPath(service)) {
                            MessageHandler.getInstance().showError(Messages.getString("canNotDeleteRestrictedSandbox"));
                            return false;
                        }
                    }
                    it.remove();
                }
                continue;
            }
            HashSet<String> set = new HashSet<String>(entry.getValue());
            if (set.contains("")) {
                if (oppositeKeysMap.containsKey(key)) {
                    ((Set)map.get(oppositeKeysMap.get(key))).addAll((Set)map.get(key));
                }
                map.put(key, new HashSet());
                continue;
            }
            if (key.equalsIgnoreCase("coldfusion.sql.DataSourcePermission") && !this.validateDbName(set, "coldfusion.sql.DataSourcePermission")) {
                return false;
            }
            if (key.equalsIgnoreCase("disabledDatasources") && !this.validateDbName(set, "disabledDatasources")) {
                return false;
            }
            HashSet<String> notPresentSet = new HashSet<String>();
            Set currentSet = (Set)map.get(key);
            for (String x : set) {
                if (currentSet.contains(x)) continue;
                notPresentSet.add(x);
            }
            if (notPresentSet.size() > 0) {
                MessageHandler.getInstance().showError(Messages.getString("errorDeletingGivenValues", StringUtils.join(notPresentSet, (String)","), ProposedSetting.getInstance().getUserDefinedValue(Category.SANDBOX, key)));
                return false;
            }
            if (oppositeKeysMap.containsKey(key)) {
                ((Set)map.get(oppositeKeysMap.get(key))).addAll(set);
            }
            ((Set)map.get(key)).removeAll(set);
        }
        this.securityService.updateSandboxData(sandboxMap, this.selectedPath, this.isAdminPath(this.selectedPath));
        this.sandboxConfigMap = map;
        return true;
    }

    @Override
    public boolean setSetting(final String name, final Object value, String service) {
        if ("sbs.security.enabled".equalsIgnoreCase(name)) {
            this.securityService.updateSandboxEnabledStatus((Boolean)value);
            this.showJeeConfigurationMessage();
            return true;
        }
        if (name.equalsIgnoreCase("directory")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        service = Util.addFileSeparator(service);
        TreeMap oldMap = new TreeMap(String.CASE_INSENSITIVE_ORDER){
            {
                this.putAll(SandboxSettings.this.sandboxConfigMap);
            }
        };
        Map v = (Map)this.sandboxConfigMap.get(service);
        Map map = new HashMap(){
            {
                this.put(name, value);
            }
        };
        if ((map = this.processSettingsOfMap(map, v, service)) == null) {
            return false;
        }
        oldMap.put(service, map);
        this.securityService.updateSandboxData(oldMap, this.selectedPath, this.isAdminPath(service));
        this.sandboxConfigMap.put(service, v);
        this.showJeeConfigurationMessage();
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        if ("sbs.security.enabled".equalsIgnoreCase(name)) {
            return String.valueOf(this.securityService.getSandboxEnabledStatus());
        }
        Map v = (Map)this.sandboxConfigMap.get(service);
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        if (object instanceof Set) {
            return StringUtils.join(new TreeSet((Set)object), (String)",");
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.securityFile;
    }

    @Override
    public Category getCategory() {
        return Category.SANDBOX;
    }

    @Override
    public Map<String, ?> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.sandboxConfigMap.forEach(map::put);
        if (AbstractCommand.commandName == CommandName.EXPORT) {
            map.forEach((k, v) -> {
                ((Map)map.get(k)).put("directory", k);
                for (String key : disallowedKeys) {
                    ((Map)map.get(k)).remove(key);
                }
            });
            map.put("sbs.security.enabled", this.securityService.getSandboxEnabledStatus());
        }
        return map;
    }

    private Map processSettingsOfMap(Map newValueMap, Map oldMap, String directory) {
        Map.Entry entry;
        Map.Entry o;
        boolean overwrite = AbstractCommand.commandName == CommandName.SET;
        HashSet<String> disallowedSet = new HashSet<String>();
        Iterator iterator = newValueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = o = iterator.next();
            Set v = (Set)entry.getValue();
            String k = (String)entry.getKey();
            if (!disallowedKeys.contains(k) || v.size() <= 0) continue;
            disallowedSet.add(k);
        }
        if (disallowedSet.size() > 0) {
            MessageHandler.getInstance().showError(Messages.getString("keyDisabled", StringUtils.join(disallowedSet, (String)",").toUpperCase(), AbstractCommand.commandName.toString(), this.getCategory().toString()));
            return null;
        }
        iterator = newValueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Set existingValue;
            entry = o = iterator.next();
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if ("java.io.FilePermission".equalsIgnoreCase(k)) {
                for (String file : (Set)v) {
                    file = file.substring(file.indexOf(":") + 1);
                    if (CommandName.IMPORT == AbstractCommand.commandName) continue;
                    if (!SecurityService.isRestrictedPath(file) || !this.isAdminPath(directory)) continue;
                    MessageHandler.getInstance().showError(Messages.getString("canNotEditFilePermission", file));
                    return null;
                }
                if (overwrite) {
                    ((Set)oldMap.get(k)).clear();
                    ((Set)oldMap.get(k)).addAll((Set)v);
                } else {
                    Iterator newFilesIterator = ((Set)v).iterator();
                    ArrayList<CallSite> toBeAdded = new ArrayList<CallSite>();
                    ArrayList<String> toBeRemoved = new ArrayList<String>();
                    while (newFilesIterator.hasNext()) {
                        String file = (String)newFilesIterator.next();
                        String fileName = file.substring(file.indexOf(":") + 1);
                        String permissions = file.substring(0, file.indexOf(":"));
                        Set oldFileList = (Set)oldMap.get(k);
                        Iterator oldFileIterator = oldFileList.iterator();
                        boolean found = false;
                        while (oldFileIterator.hasNext()) {
                            String oldFile = (String)oldFileIterator.next();
                            String oldFileName = oldFile.substring(oldFile.indexOf(":") + 1);
                            String oldPermissions = oldFile.substring(0, oldFile.indexOf(":"));
                            if (!oldFileName.equals(fileName)) continue;
                            found = true;
                            if (oldPermissions.equals(permissions)) continue;
                            toBeAdded.add((CallSite)((Object)(permissions + ":" + fileName)));
                            toBeRemoved.add(fileName);
                        }
                        if (found) continue;
                        toBeAdded.add((CallSite)((Object)(permissions + ":" + fileName)));
                    }
                    ((Set)oldMap.get(k)).removeAll(toBeRemoved);
                    ((Set)oldMap.get(k)).addAll(toBeAdded);
                }
            } else if ("java.net.SocketPermission".equalsIgnoreCase(k)) {
                Set newSockets = (Set)v;
                HashSet existingSockets = (HashSet)oldMap.get(k);
                if (existingSockets != null) {
                    existingSockets = new HashSet();
                }
                newSockets.addAll(existingSockets);
                oldMap.put(k, newSockets);
            } else if ("coldfusion.sql.DataSourcePermission".equalsIgnoreCase(k)) {
                Set datasources = (Set)v;
                if (datasources.contains("*")) {
                    datasources.clear();
                    datasources.add("*");
                    oldMap.put(k, datasources);
                } else {
                    existingValue = (HashSet)oldMap.get("coldfusion.sql.DataSourcePermission");
                    if (existingValue == null) {
                        existingValue = new HashSet();
                    }
                    if (!overwrite) {
                        if (existingValue.contains("*")) {
                            datasources.clear();
                            datasources.add("*");
                        } else {
                            existingValue.addAll(datasources);
                        }
                    }
                    oldMap.put(k, datasources);
                }
            } else if ("disabledRuntimePermissions".equalsIgnoreCase(k)) {
                if (((Set)v).contains("*")) {
                    oldMap.put("java.lang.RuntimePermission", new HashSet());
                } else {
                    Set enabledPermissions = (Set)oldMap.get("java.lang.RuntimePermission");
                    enabledPermissions.removeAll((Set)v);
                    oldMap.put("java.lang.RuntimePermission", enabledPermissions);
                }
            } else if ("coldfusion.tagext.GenericTagPermission".equalsIgnoreCase(k) || "coldfusion.runtime.FunctionPermission".equalsIgnoreCase(k)) {
                Set newValues = (Set)v;
                existingValue = (Set)oldMap.get(k);
                if (existingValue == null) {
                    existingValue = new HashSet();
                }
                newValues.addAll(existingValue);
                oldMap.put(k, newValues);
            } else {
                oldMap.put(k, v);
            }
            if (!oppositeKeysMap.containsKey(k) || !oldMap.containsKey(oppositeKeysMap.get(k))) continue;
            if (((Set)v).contains("*")) {
                oldMap.put(oppositeKeysMap.get(k), new HashSet());
                continue;
            }
            ((Set)oldMap.get(oppositeKeysMap.get(k))).removeAll((Set)v);
        }
        return oldMap;
    }

    @Override
    public boolean validate(Map<String, Object> keyValueMap, String service) {
        HashSet<String> disabledDatasources;
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            String key = entry.getKey();
            if (key.equalsIgnoreCase("sbs.security.enabled")) continue;
            Object object = entry.getValue();
            if ("directory".equals(key)) continue;
            keyValueMap.put(key, new HashSet((List)object));
        }
        HashSet<String> ips = keyValueMap.containsKey("java.net.SocketPermission") ? (Set)keyValueMap.get("java.net.SocketPermission") : new HashSet();
        HashSet<String> datasources = keyValueMap.containsKey("coldfusion.sql.DataSourcePermission") ? (Set)keyValueMap.get("coldfusion.sql.DataSourcePermission") : new HashSet();
        Set set = disabledDatasources = keyValueMap.containsKey("disabledDatasources") ? (Set)keyValueMap.get("disabledDatasources") : new HashSet();
        if (!this.validateDbName(datasources, "coldfusion.sql.DataSourcePermission") || !this.validateDbName(disabledDatasources, "disabledDatasources")) {
            return false;
        }
        Set<String> goodIps = this.formatIps(ips);
        if (goodIps.size() != ips.size()) {
            return false;
        }
        if (keyValueMap.containsKey("java.net.SocketPermission")) {
            keyValueMap.put("java.net.SocketPermission", goodIps);
        }
        return true;
    }

    public boolean validateDbName(Set<String> currDatasources, String settingName) {
        if (currDatasources.contains("*")) {
            return true;
        }
        Set<String> datasources = new DatasourceSettings(this.selectedPath).getMap().keySet();
        HashSet<String> currDatasourcesPlaceholder = new HashSet<String>();
        currDatasourcesPlaceholder.addAll(currDatasources);
        currDatasourcesPlaceholder.removeAll(datasources);
        if (currDatasourcesPlaceholder.size() > 0) {
            TreeSet<String> sortedDatasources = new TreeSet<String>(datasources);
            String dbName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), settingName);
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", dbName));
            Util.printAllowedValues(dbName, sortedDatasources);
            return false;
        }
        return true;
    }

    private Set<String> formatIps(Set<String> ips) {
        HashSet<String> faultyIps = new HashSet<String>();
        HashSet<String> goodIps = new HashSet<String>();
        boolean isValid = true;
        for (String x : ips) {
            String x2;
            int piv;
            String port;
            boolean ipv6;
            boolean bl = ipv6 = x.contains("[") && x.length() >= 2;
            String ip = !ipv6 ? x.substring(x.indexOf(";") + 1, x.indexOf(":") == -1 ? x.length() : x.indexOf(":")) : x.substring(x.indexOf(";") + 2, x.indexOf("]") == -1 ? x.length() : x.indexOf("]"));
            boolean bl2 = isValid = Pattern.matches("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$", ip) || Pattern.matches("^([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})\\:([0-9a-zA-Z]{1,4})$", ip) || Pattern.matches("^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$", ip);
            if (ipv6 && x.indexOf("]") == x.length() - 1 || !ipv6 && x.indexOf(":") == -1) {
                goodIps.add("connect,resolve;" + x.substring(x.indexOf(59) + 1));
                continue;
            }
            if (ipv6 && (x.charAt(x.indexOf(93) + 1) != ':' || x.charAt(x.indexOf(59) + 1) != '[')) {
                faultyIps.add(x);
                continue;
            }
            String string = port = ipv6 ? x.substring(x.indexOf("]") + 2) : x.substring(x.indexOf(":") + 1);
            if (StringUtils.isEmpty((String)port) || "-".equals(port)) {
                isValid = false;
            }
            String x1 = (piv = port.indexOf(45)) <= 0 ? "0" : port.substring(0, port.indexOf(45));
            String string2 = x2 = piv == port.length() - 1 ? "0" : port.substring(port.indexOf(45) + 1);
            if (!(!isValid || NumberUtils.isDigits((String)x1) && NumberUtils.isDigits((String)x2))) {
                isValid = false;
            }
            if (!isValid) {
                faultyIps.add(x);
                continue;
            }
            goodIps.add("connect,resolve;" + x.substring(x.indexOf(59) + 1));
        }
        if (faultyIps.size() > 0) {
            String settingName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "java.net.SocketPermission");
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", settingName));
            MessageHandler.getInstance().showInfo(StringUtils.join(faultyIps, (String)", "));
        }
        return goodIps;
    }

    private boolean isAdminPath(String directory) {
        String cfide = this.selectedPath + File.separator + "wwwroot" + File.separator + "CFIDE";
        String webinf = this.selectedPath + File.separator + "wwwroot" + File.separator + "WEB-INF";
        return directory.startsWith(cfide) || directory.startsWith(webinf);
    }

    @Override
    public void show(String service) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            super.show(service);
            Util.showSingleSetting(this.getCategory(), "sbs.security.enabled", this.securityService.getSandboxEnabledStatus());
            return;
        }
        super.show(service);
    }

    @Override
    public String showSuffix() {
        return "(s)";
    }

    private void showJeeConfigurationMessage() {
        if (Util.isJEEDeployment(this.selectedPath) && AbstractCommand.commandName != CommandName.IMPORT) {
            String jvmFlag = "-Djava.security.manager -Djava.security.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "coldfusion.policy -Djava.security.auth.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "neo_jaas.policy";
            MessageHandler.getInstance().showInfo(Messages.getString("SANDBOX.enableJvmArguments", jvmFlag));
        }
    }
}

