/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.nested;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class MappingsSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private String runtimeMappingsXml = Category.RUNTIME.getFileName();
    private File runtimeMappingsXmlFile;
    private Map<String, Object> runtimeMappingsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> cfsetupMapping;
    private RuntimeService service;

    public MappingsSettings(String instancePath) {
        super(instancePath);
        this.runtimeMappingsXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + this.runtimeMappingsXml);
        this.intialize();
    }

    private void intialize() {
        this.service = new RuntimeService(this.runtimeMappingsXmlFile, this.runtimeMappingsXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public String getSetting(String name, String service) {
        throw new CFSetupException(Messages.getString("operationNotSupported2", this.getCategory().name().toLowerCase()));
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("virtual")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if ("/CFIDE".equalsIgnoreCase(service) && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", "/CFIDE"));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)service) || !this.cfsetupMapping.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        Map map = (Map)this.cfsetupMapping.get(service);
        map.put(name, String.valueOf(value));
        return this.service.saveModifiedMappingMap(this.runtimeMappingsMap);
    }

    @Override
    public boolean addService(Object val) {
        Map input = (Map)val;
        String virtual = (String)input.get("virtual");
        String physical = (String)input.get("physical");
        if ("/CFIDE".equalsIgnoreCase(virtual) && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", "/CFIDE"));
            return false;
        }
        Map map = this.cfsetupMapping.getOrDefault(virtual, new HashMap());
        map.put("virtual", virtual);
        map.put("physical", physical);
        this.cfsetupMapping.put(virtual, map);
        this.runtimeMappingsMap.put(virtual, physical);
        return this.service.saveModifiedMappingMap(this.runtimeMappingsMap);
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service) || !this.cfsetupMapping.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        this.cfsetupMapping.remove(service);
        this.runtimeMappingsMap.remove(service);
        return this.service.saveModifiedMappingMap(this.runtimeMappingsMap);
    }

    @Override
    public void populateMap() {
        this.runtimeMappingsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.cfsetupMapping = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.runtimeMappingsMap.putAll(this.service.getMappings());
        this.runtimeMappingsMap.forEach((virtual, physical) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("virtual", (String)virtual);
            map.put("physical", String.valueOf(physical));
            this.cfsetupMapping.put((String)virtual, map);
        });
    }

    @Override
    public Map<String, Object> getMap() {
        return this.cfsetupMapping;
    }

    @Override
    public File getXMLFileObject() {
        return this.runtimeMappingsXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.MAPPING;
    }

    @Override
    public void show(String service) {
        super.show(service);
    }
}

