/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.nested;

import coldfusion.saml.IdpConfiguration;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.SamlService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdentityProviderSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(SamlIdentityProviderSettings.class);
    private static final String NAME = "name";
    private final File samlIpConfigXmlFile;
    private Map<String, Map<String, Object>> idpConfigMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
    private SamlService samlService;

    public SamlIdentityProviderSettings(String instancePath) {
        super(instancePath);
        this.samlIpConfigXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + Category.IDPCONFIGURATION.getFileName());
        this.samlService = new SamlService(this.samlIpConfigXmlFile, this.samlIpConfigXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.idpConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public File getXMLFileObject() {
        return this.samlIpConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.IDPCONFIGURATION;
    }

    @Override
    public void populateMap() {
        this.idpConfigMap.clear();
        this.samlService.getAllIdpConfig().forEach((idpName, idpConfiguration) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            if (idpConfiguration instanceof Map) {
                map.putAll((Map)idpConfiguration);
            } else {
                map.putAll((Map)new ObjectMapper().convertValue(idpConfiguration, Map.class));
            }
            map.put(NAME, (String)idpName);
            this.idpConfigMap.put((String)idpName, (Map<String, Object>)map);
        });
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError("Please Provide IDP Configuration name");
        }
        if (!this.idpConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid IDP Configuration name");
            return null;
        }
        Map<String, Object> idpConfig = this.idpConfigMap.get(service);
        if (!idpConfig.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return String.valueOf(idpConfig.get(name));
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.idpConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", Category.IDPCONFIGURATION.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.IDPCONFIGURATION.name()));
        }
        try {
            String oldName;
            Map<String, Object> idpConfig = this.idpConfigMap.get(service);
            idpConfig.put(name, newValue);
            if (NAME.equalsIgnoreCase(name)) {
                this.idpConfigMap.remove(service);
                this.idpConfigMap.put(String.valueOf(newValue), idpConfig);
            }
            String newName = oldName = service;
            if (!NAME.equalsIgnoreCase(name)) {
                idpConfig.put(name, newValue);
            } else {
                newName = (String)newValue;
            }
            IdpConfiguration idpConfiguration = this.getIdpConfiguration(idpConfig);
            this.samlService.modifyIdpMetadata(oldName, newName, idpConfiguration);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private IdpConfiguration getIdpConfiguration(Map<String, Object> idpConfig) {
        Object value = idpConfig.remove(NAME);
        IdpConfiguration idpConfiguration = (IdpConfiguration)new ObjectMapper().convertValue(idpConfig, IdpConfiguration.class);
        idpConfig.put(NAME, value);
        return idpConfiguration;
    }

    @Override
    public boolean addService(Object val) {
        try {
            Map map = (Map)val;
            String alias = (String)map.get(NAME);
            IdpConfiguration idpConfiguration = this.getIdpConfiguration(map);
            if (this.idpConfigMap.containsKey(alias)) {
                this.samlService.modifyIdpMetadata(alias, alias, idpConfiguration);
            } else {
                this.samlService.addIdpMetadata(alias, idpConfiguration);
            }
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("Invalid IDP Configuration name"));
            return false;
        }
        if (!this.idpConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid IDP Configuration name");
            return false;
        }
        this.idpConfigMap.remove(service);
        try {
            this.samlService.deleteIdpMetadata(service);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

