/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.nested;

import coldfusion.saml.SpConfiguration;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.nested.SamlIdentityProviderSettings;
import com.adobe.cfsetup.settings.service.SamlService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlServiceProviderSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(SamlIdentityProviderSettings.class);
    private static final String NAME = "name";
    private final File samlSpConfigXmlFile;
    private Map<String, Map<String, Object>> spConfigMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
    private SamlService samlService;

    public SamlServiceProviderSettings(String instancePath) {
        super(instancePath);
        this.samlSpConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SPCONFIGURATION.getFileName());
        this.samlService = new SamlService(this.samlSpConfigXmlFile, this.samlSpConfigXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.spConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public File getXMLFileObject() {
        return this.samlSpConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.SPCONFIGURATION;
    }

    @Override
    public void populateMap() {
        this.spConfigMap.clear();
        this.samlService.getAllSpConfig().forEach((spName, spConfiguration) -> {
            TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            if (spConfiguration instanceof Map) {
                map.putAll((Map)spConfiguration);
            } else {
                map.putAll((Map)new ObjectMapper().convertValue((Object)((SpConfiguration)spConfiguration), Map.class));
            }
            map.put(NAME, (String)spName);
            this.spConfigMap.put((String)spName, (Map<String, Object>)map);
        });
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError("Please Provide SP Configuration name");
        }
        if (!this.spConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid Sp Configuration name");
            return null;
        }
        Map<String, Object> spConfig = this.spConfigMap.get(service);
        if (!spConfig.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return String.valueOf(spConfig.get(name));
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.spConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.SPCONFIGURATION.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.SPCONFIGURATION.name()));
        }
        try {
            String oldName;
            Map<String, Object> spConfig = this.spConfigMap.get(service);
            spConfig.put(name, newValue);
            if (NAME.equalsIgnoreCase(name)) {
                this.spConfigMap.remove(service);
                this.spConfigMap.put(String.valueOf(newValue), spConfig);
            }
            String newName = oldName = service;
            if (!NAME.equalsIgnoreCase(name)) {
                spConfig.put(name, newValue);
            } else {
                newName = (String)newValue;
            }
            SpConfiguration spConfiguration = this.getSpConfiguration(spConfig);
            this.samlService.modifySpMetadata(oldName, newName, spConfiguration);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private SpConfiguration getSpConfiguration(Map<String, Object> spConfig) {
        Object value = spConfig.remove(NAME);
        SpConfiguration spConfiguration = (SpConfiguration)new ObjectMapper().convertValue(spConfig, SpConfiguration.class);
        spConfig.put(NAME, value);
        return spConfiguration;
    }

    @Override
    public boolean addService(Object val) {
        try {
            Map map = (Map)val;
            String alias = (String)map.get(NAME);
            SpConfiguration spConfiguration = this.getSpConfiguration(map);
            if (!this.spConfigMap.containsKey(alias)) {
                this.samlService.addSpMetadata(alias, spConfiguration);
            } else {
                this.samlService.modifySpMetadata(alias, alias, spConfiguration);
            }
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("Invalid SP Configuration name"));
            return false;
        }
        if (!this.spConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid SP Configuration name");
            return false;
        }
        this.spConfigMap.remove(service);
        try {
            this.samlService.deleteSpMetadata(service);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

