/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.stream.Collectors;

public class DebugService
extends ServiceBase {
    private ConfigMap settings = new ConfigMap();
    private ConfigMap iplist = new ConfigMap();
    private ConfigMap lineDebugSettings = new ConfigMap();
    private ConfigMap remoteInspectionSettings = new ConfigMap();
    private File file;
    List<String> settingsField = Arrays.asList("applicationvar", "lockrelease", "xml_template", "http", "objectquery", "trace", "debug_template", "lockwarning", "template_highlight_minimum", "general", "clientvar", "storedprocedure", "database", "urlvar", "variables", "enabled", "cgivar", "lockcreate", "sqlquery", "template_mode", "robust_enabled", "ajax_enabled", "template", "sessionvar", "exception", "requestvar", "cookievar", "lockacquire", "developer_enabled", "executiontime", "servervar", "formvar", "TIMER", "FLASHFORMCOMPILEERRORS");
    List<String> ipListFields = Arrays.asList("iplist");
    List<String> lineDebugSettingsField = Arrays.asList("LINE_DEBUGGER_PORT", "LINE_DEBUGGER_ENABLED", "MAX_DEBUG_SESSIONS");
    List<String> remoteInspectionSettingsFields = Arrays.asList("USE_WEINRE_ADVANCED_SETTINGS", "LOCAL_WEINRE_IP", "IS_LOCAL_WEINRE_INSTALLED", "LOCAL_WEINRE_READ_TIMEOUT", "LOCAL_WEINRE_PORT", "REMOTE_INSPECTION_ENABLED", "LOCAL_WEINRE_DEATH_TIMEOUT", "WEINRE_SERVER_TYPE", "WEINRE_SERVER_URL");

    public DebugService(File debugConfigXmlFile) {
        this.file = debugConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading debug settings, ", e);
        }
    }

    public Map getMap() {
        HashMap map = new HashMap();
        this.settings.forEach((key, value) -> map.put((String)key, value));
        this.iplist.forEach((key, value) -> {
            if (!"developer_enabled".equals(key)) {
                map.put((String)key, value);
            }
        });
        this.lineDebugSettings.forEach((key, value) -> map.put((String)key, value));
        this.remoteInspectionSettings.forEach((key, value) -> map.put((String)key, value));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.settings = (ConfigMap)v.elementAt(0);
            this.iplist = (ConfigMap)v.elementAt(1);
            if (v.size() > 2) {
                this.lineDebugSettings = (ConfigMap)v.elementAt(2);
            }
            if (v.size() > 3) {
                this.remoteInspectionSettings = (ConfigMap)v.elementAt(3);
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedMap(Map map, boolean isDeveloperEnabledChanged) {
        this.updateMap(this.settings, this.settingsField, map);
        this.updateMap(this.iplist, this.ipListFields, map);
        this.updateMap(this.lineDebugSettings, this.lineDebugSettingsField, map);
        this.updateMap(this.remoteInspectionSettings, this.remoteInspectionSettingsFields, map);
        if (isDeveloperEnabledChanged && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            this.setDeveloperEnabled(Cast._boolean(map.get("developer_enabled")));
        }
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.settings);
        v.addElement(this.iplist);
        if (!this.lineDebugSettings.isEmpty()) {
            v.addElement(this.lineDebugSettings);
        }
        if (!this.remoteInspectionSettings.isEmpty()) {
            v.addElement(this.remoteInspectionSettings);
        }
        this.serialize(v, this.file);
    }

    private void updateMap(ConfigMap configMap, List<String> fields, Map map) {
        configMap.clear();
        configMap.putAll(map.entrySet().stream().filter(v -> fields.contains(((Map.Entry)v).getKey())).collect(Collectors.toMap(v -> ((Map.Entry)v).getKey(), v -> ((Map.Entry)v).getValue())));
    }

    public boolean isRobustEnabledInAdministrator() {
        Boolean b = (Boolean)this.settings.get("robust_enabled");
        return b == null ? false : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeveloperEnabled(boolean isDeveloperEnabled) {
        RuntimeService runtimeSvc = new RuntimeService(new File(this.file.getParent() + File.separator + Category.RUNTIME.getFileName()), this.file.getParent().replace(File.separator + "lib", ""));
        if (isDeveloperEnabled) {
            FileOutputStream fileOut = null;
            try {
                Properties properties = new Properties();
                properties.setProperty("istrustedcache", "" + runtimeSvc.isTrustedCache());
                properties.setProperty("robust_enabled", "" + this.isRobustEnabledInAdministrator());
                properties.setProperty("restdiscovery", "" + runtimeSvc.isAllowRestDiscovery());
                File devproffile = new File(this.file.getParent() + File.separatorChar + "devprof.properties");
                fileOut = new FileOutputStream(devproffile);
                properties.store(fileOut, "Settings before dev profile was enabled.");
            }
            catch (FileNotFoundException properties) {
            }
            catch (IOException properties) {
            }
            finally {
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException properties) {}
                }
            }
            this.settings.put("developer_enabled", isDeveloperEnabled ? Boolean.TRUE : Boolean.FALSE);
            this.settings.put("robust_enabled", isDeveloperEnabled ? Boolean.TRUE : Boolean.FALSE);
            runtimeSvc.setTrustedCache(!isDeveloperEnabled);
            runtimeSvc.setAllowRestDiscovery(isDeveloperEnabled);
        } else if (!isDeveloperEnabled) {
            Properties prop = new Properties();
            FileInputStream input = null;
            File devProf = new File(this.file.getParent() + File.separatorChar + "devprof.properties");
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && devProf != null && devProf.exists()) {
                try {
                    input = new FileInputStream(devProf);
                    prop.load(input);
                    runtimeSvc.setTrustedCache(Boolean.parseBoolean(prop.getProperty("istrustedcache")));
                    runtimeSvc.setAllowRestDiscovery(Boolean.parseBoolean(prop.getProperty("restdiscovery")));
                    this.settings.put("robust_enabled", (Object)Boolean.parseBoolean(prop.getProperty("robust_enabled")));
                    this.settings.put("developer_enabled", isDeveloperEnabled ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                this.settings.put("developer_enabled", isDeveloperEnabled ? Boolean.TRUE : Boolean.FALSE);
                this.settings.put("robust_enabled", isDeveloperEnabled ? Boolean.TRUE : Boolean.FALSE);
                runtimeSvc.setTrustedCache(!isDeveloperEnabled);
                runtimeSvc.setAllowRestDiscovery(isDeveloperEnabled);
            }
        }
    }
}

