/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;

public class GraphQLClientConfigService
extends ServiceBase
implements Observer {
    private ConfigMap settings;
    private File file;
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private static final Set<String> fieldsToBeEncrypted = SetUtils.unmodifiableSet(new HashSet<String>(Arrays.asList("headers")));
    private String seed;

    public GraphQLClientConfigService(File inputFile) {
        this.file = inputFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading graphql client settings, ", e);
        }
    }

    public Map getMap() {
        HashMap map = new HashMap();
        if (!Objects.isNull(this.settings)) {
            map.putAll(this.settings);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.file);
            if (this.settings == null) {
                this.settings = new ConfigMap();
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedMap(Map map) {
        this.settings.clear();
        Map m = this.formGraphQLClientSetting(map);
        this.settings.putAll(m);
        this.store();
    }

    public void addService(String serviceName, Map<String, Object> settings) {
        Map m = this.formGraphQLClientSetting(settings);
        this.settings.put(serviceName, m);
        this.store();
    }

    private Map formGraphQLClientSetting(Map<String, Object> map) {
        ConfigMap resultMap = new ConfigMap();
        map.forEach((key, val) -> {
            if (val instanceof Map) {
                resultMap.put(key, this.formGraphQLClientSetting((Map)val));
            } else if ("headers".equals(key) && !val.equals("{}")) {
                this.processHeaders(resultMap, (String)key, val);
            } else {
                resultMap.put(key, val);
            }
        });
        this.encryptField(resultMap);
        return resultMap;
    }

    private void encryptField(Map struct) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, this.encryptOnlyValues((Map)struct.get(fieldName)));
            }
        });
    }

    private Map encryptOnlyValues(Map src) {
        src.forEach((key, value) -> src.put(key, PasswordUtils.encryptPassword((String)value, PasswordUtils.getInstance().getSeedValue())));
        return src;
    }

    public void decryptField(Map struct, String seed) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, this.decryptOnlyValues((Map)struct.get(fieldName), seed));
            }
        });
    }

    private Map decryptOnlyValues(Map src, String seed) {
        HashMap headersStruct = new HashMap();
        src.forEach((key, value) -> headersStruct.put(key, PasswordUtils.decryptPassword((String)value, seed)));
        return headersStruct;
    }

    private void processHeaders(Map resultMap, String key, Object val) {
        String[] tuples;
        ConfigMap valMap = new ConfigMap();
        String stringifiedMap = (String)val;
        stringifiedMap = stringifiedMap.substring(1, stringifiedMap.length() - 1);
        for (String tuple : tuples = stringifiedMap.split(",")) {
            String[] header = tuple.split("=");
            valMap.put(header[0], header[1]);
        }
        resultMap.put(key, valMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            String string = seedVal;
            synchronized (string) {
                this.reEncryptPasswords(oldSeed);
            }
        }
    }

    private void reEncryptPasswords(String oldSeed) {
        this.settings.forEach((k, v) -> {
            this.decryptField((Map)v, oldSeed);
            this.encryptField((Map)v);
        });
        this.store();
    }
}

