/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.cloud.consumer.metadata.GraphQLServiceConfigMetadata;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.Array;
import coldfusion.server.ServiceException;
import coldfusion.util.RB;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlNodeArray;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlNodeMap;
import coldfusion.xml.XmlProcessor;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.bean.ServiceConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.SetUtils;
import org.apache.xerces.dom.DeferredTextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GraphQLServiceConfigService
extends ServiceBase
implements Observer {
    XmlNodeList serviceConfig;
    private File file;
    private Map serviceConfigMap = new LinkedHashMap();
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private static final Set<String> fieldsToBeEncrypted = SetUtils.unmodifiableSet(new HashSet<String>(Arrays.asList("headers")));
    private String seed;
    private XmlNodeList services;
    Set<String> listNodes = new HashSet<String>(Arrays.asList("plugins", "dependencies"));
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public GraphQLServiceConfigService(File serviceSettingsFile) {
        if (serviceSettingsFile.exists()) {
            this.file = serviceSettingsFile;
            try {
                this.readServiceConfigFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readServiceConfigFile() throws IOException {
        StringBuilder sb = new StringBuilder();
        Files.readAllLines(Paths.get(this.file.getAbsolutePath(), new String[0])).forEach(line -> {
            sb.append((String)line);
            sb.append("\n");
        });
        this.serviceConfig = XmlProcessor.parse(sb.toString(), true);
        this.services = (XmlNodeList)((Array)XmlProcessor.search(this.serviceConfig, "/project/build/plugins/plugin/executions/execution/configuration/services", null)).get(0);
        this.serviceConfigMap.clear();
        this.convertToMap(this.services.getFirstNode(), this.serviceConfigMap);
        this.flattenServiceMap();
    }

    private void convertToMap(Node node, Map map) {
        if (!node.hasChildNodes() && node.getTextContent().trim().length() > 0) {
            map.put(node.getNodeName(), node.getTextContent());
        } else {
            if (!node.hasChildNodes() && node.getTextContent().trim().length() == 0) {
                return;
            }
            NodeList children = node.getChildNodes();
            int numberOfChildren = children.getLength();
            if (this.listNodes.contains(node.getNodeName())) {
                ArrayList list = new ArrayList();
                for (int i = 0; i < numberOfChildren; ++i) {
                    Node child = children.item(i);
                    LinkedHashMap childMap = new LinkedHashMap();
                    this.convertToMap(child, childMap);
                    if (childMap.isEmpty()) continue;
                    list.add(childMap);
                }
                map.put(node.getNodeName(), list);
            } else if (numberOfChildren == 1 && node.getFirstChild() instanceof DeferredTextImpl) {
                map.put(node.getNodeName(), node.getFirstChild().getTextContent());
            } else {
                LinkedHashMap childrenMap = new LinkedHashMap();
                for (int i = 0; i < numberOfChildren; ++i) {
                    Node child = children.item(i);
                    this.convertToMap(child, childrenMap);
                }
                map.put(node.getNodeName(), childrenMap);
            }
        }
    }

    public void addServiceConfig(Map inputMap) throws ServiceException {
        FileWriter fileWriter = null;
        try {
            ServiceConfig serviceConfig = new ServiceConfig();
            this.filler.fillObject(serviceConfig, inputMap, GraphQLServiceConfigMetadata.getInstance().getConsumerMap());
            String serviceName = serviceConfig.getServiceName();
            if (this.serviceConfigMap.containsKey(serviceName)) {
                this.updateServiceConfig(serviceName, inputMap);
            }
            XmlNodeArray servicesChilrenArray = this.addChildToNode(this.services, serviceName);
            XmlNodeList newService = (XmlNodeList)servicesChilrenArray.get(servicesChilrenArray.size() - 1);
            XmlNodeArray newServiceChildrenArray = this.addChildToNode(newService, "compilationUnit");
            XmlNodeList compilationUnit = (XmlNodeList)newServiceChildrenArray.get(newServiceChildrenArray.size() - 1);
            XmlNodeArray compilationUnitChildrenArray = this.addChildToNode(compilationUnit, "name", serviceName);
            compilationUnitChildrenArray = this.addChildToNode(compilationUnit, "compilerParams");
            XmlNodeList compilerParams = (XmlNodeList)compilationUnitChildrenArray.get(compilationUnitChildrenArray.size() - 1);
            XmlNodeArray compilerParamsChildrenArray = this.addChildToNode(compilerParams, "rootPackageName", serviceConfig.getRootPackageName());
            if (serviceConfig.getCustomTypes() != null) {
                compilerParamsChildrenArray = this.addChildToNode(compilerParams, "customTypeMapping");
                XmlNodeList customTypeMapping = (XmlNodeList)compilerParamsChildrenArray.get(compilerParamsChildrenArray.size() - 1);
                serviceConfig.getCustomTypes().forEach(type -> this.addChildToNode(customTypeMapping, (String)type, "coldfusion.graphql.client.CustomScalar"));
            }
            if (serviceConfig.getServiceUrl() != null) {
                newServiceChildrenArray = this.addChildToNode(newService, "introspection");
                XmlNodeList introspection = (XmlNodeList)newServiceChildrenArray.get(newServiceChildrenArray.size() - 1);
                this.addChildToNode(introspection, "enabled", "true");
                this.addChildToNode(introspection, "endpointUrl", serviceConfig.getServiceUrl());
                XmlNodeArray introspectionchildrenArray = this.addChildToNode(introspection, "headers");
                XmlNodeList headers = (XmlNodeList)introspectionchildrenArray.get(introspectionchildrenArray.size() - 1);
                if (Objects.nonNull(serviceConfig.getHeaders())) {
                    Map encryptedHeaders = this.encryptOnlyValues(serviceConfig.getHeaders());
                    encryptedHeaders.forEach((key, value) -> this.addChildToNode(headers, (String)key, (String)value));
                }
                this.addChildToNode(introspection, "connectTimeoutSeconds", "10");
                this.addChildToNode(introspection, "readTimeoutSeconds", "10");
                this.addChildToNode(introspection, "writeTimeoutSeconds", "10");
                this.addChildToNode(introspection, "useSelfSignedCertificat", "false");
                this.addChildToNode(introspection, "useGzip", "false");
            }
            if (serviceConfig.getSchemaPath() != null) {
                newServiceChildrenArray = this.addChildToNode(newService, "schemaPath", "${cfusion.home}/" + serviceConfig.getSchemaPath());
            }
            fileWriter = this.writeServiceConfigFile(this.serviceConfig.toString());
            this.readServiceConfigFile();
            this.closeFileWriter(fileWriter);
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                this.closeFileWriter(fileWriter);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWriter writeServiceConfigFile(String content) throws IOException {
        try {
            this.writeLock.lock();
            FileWriter fileWriter = new FileWriter(this.file);
            fileWriter.write(content);
            fileWriter.flush();
            FileWriter fileWriter2 = fileWriter;
            return fileWriter2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void closeFileWriter(FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private XmlNodeArray addChildToNode(XmlNodeList node, String childName) {
        return this.addChildToNode(node, childName, "");
    }

    private XmlNodeArray addChildToNode(XmlNodeList node, String childName, String text) {
        XmlNodeArray childrenArray = (XmlNodeArray)new XmlNodeMap(node).get("XmlChildren");
        XmlNodeList childNode = XmlFunctions.XmlElementNew(this.serviceConfig, childName);
        childNode.getFirstNode().setTextContent(text);
        childrenArray.add(childNode);
        return childrenArray;
    }

    public void updateServiceConfig(String oldServiceName, Map updatedConfigStruct) throws ServiceException {
        try {
            this.deleteServiceConfig(oldServiceName);
            this.addServiceConfig(updatedConfigStruct);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void deleteServiceConfig(String name) throws ServiceException {
        if (!this.serviceConfigMap.containsKey(name)) {
            throw new ValidationException(RB.getString(GraphQLServiceConfigService.class, "GraphQLServiceConfigService.ServiceNameAbsentException"));
        }
        FileWriter fileWriter = null;
        try {
            String configString = this.serviceConfig.toString();
            int serviceStartIndex = configString.indexOf("<" + name + ">");
            int serviceEndIndex = this.serviceConfig.toString().indexOf("</" + name + ">");
            String resultServiceConfig = configString.substring(0, serviceStartIndex) + configString.substring(serviceEndIndex + 3 + name.length(), configString.length());
            fileWriter = this.writeServiceConfigFile(resultServiceConfig);
            this.readServiceConfigFile();
            this.closeFileWriter(fileWriter);
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                this.closeFileWriter(fileWriter);
                throw throwable;
            }
        }
    }

    private void flattenServiceMap() {
        if (this.serviceConfigMap.get("services") instanceof String) {
            this.serviceConfigMap.clear();
            return;
        }
        this.serviceConfigMap = (Map)this.serviceConfigMap.get("services");
        Set serviceNames = this.serviceConfigMap.keySet();
        LinkedHashMap flattenedServiceMap = new LinkedHashMap();
        serviceNames.forEach(serviceName -> {
            LinkedHashMap<String, String> flattenedServiceBody = new LinkedHashMap<String, String>();
            Map serviceBody = (Map)this.serviceConfigMap.get(serviceName);
            Map compilationUnit = (Map)serviceBody.get("compilationUnit");
            Map compilerParams = (Map)compilationUnit.get("compilerParams");
            Map introspection = (Map)serviceBody.get("introspection");
            flattenedServiceBody.put("service_name", (String)serviceName);
            flattenedServiceBody.put("root_package_name", (String)compilerParams.get("rootPackageName"));
            if (Objects.nonNull(introspection)) {
                flattenedServiceBody.put("service_url", introspection.getOrDefault("endpointUrl", null));
                flattenedServiceBody.put("headers", introspection.getOrDefault("headers", null));
            }
            if (Objects.nonNull(serviceBody.get("schemaPath"))) {
                flattenedServiceBody.put("schema_path", ((String)serviceBody.get("schemaPath")).substring("${cfusion.home}/".length()));
            }
            flattenedServiceMap.put(serviceName, flattenedServiceBody);
        });
        this.serviceConfigMap = flattenedServiceMap;
    }

    private void encryptField(Map struct) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, this.encryptOnlyValues((Map)struct.get(fieldName)));
            }
        });
    }

    private Map encryptOnlyValues(Map src) {
        src.forEach((key, value) -> src.put(key, PasswordUtils.encryptPassword((String)value, PasswordUtils.getInstance().getSeedValue())));
        return src;
    }

    public void decryptField(Map struct, String seed) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, this.decryptOnlyValues((Map)struct.get(fieldName), seed));
            }
        });
    }

    private Map decryptOnlyValues(Map src, String seed) {
        HashMap headersStruct = new HashMap();
        src.forEach((key, value) -> headersStruct.put(key, PasswordUtils.decryptPassword((String)value, seed)));
        return headersStruct;
    }

    public Map getMap() {
        HashMap map = new HashMap();
        map.putAll(this.serviceConfigMap);
        return Collections.unmodifiableMap(map);
    }

    public void addService(String service, Map<String, Object> settings) throws ServiceException {
        this.addServiceConfig(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            String string = seedVal;
            synchronized (string) {
                this.reEncryptPasswords(oldSeed);
            }
        }
    }

    private void reEncryptPasswords(String oldSeed) {
        this.serviceConfigMap.forEach((k, v) -> {
            this.decryptField((Map)v, oldSeed);
            this.encryptField((Map)v);
        });
        try {
            this.writeServiceConfigFile(this.serviceConfig.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

