/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.util.OrderedProperties;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmService {
    private static final Logger logger = LoggerFactory.getLogger(JvmService.class);
    private OrderedProperties orderedProperties;
    private final File jvmFile;
    public static final String MIN_HEAP_SIZE = "Xms";
    public static final String MAX_HEAP_SIZE = "Xmx";
    public static final String MAX_METASPACE_SIZE = "MaxMetaspaceSize";
    public static final String JAVA_ARGS = "jvmArgs";
    public static final String CLASSPATH = "classpath";
    public static final String JDK_PATH = "jdkPath";

    public JvmService(File jvmFile) {
        this.jvmFile = jvmFile;
        try {
            this.orderedProperties = this.getJVMConfig(jvmFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.error("Error initializing JvmService", (Throwable)e);
        }
    }

    public String getJavaArgsList(String jvmConfig, List args) throws FileNotFoundException, IOException {
        return this.getJavaArgsList(jvmConfig, args, true);
    }

    public String getJavaArgsList(String jvmConfig, List args, boolean removeClasspath) throws FileNotFoundException, IOException {
        String obj = this.getJavaArgs();
        StringTokenizer tok = new StringTokenizer(obj, " ");
        String retString = null;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (removeClasspath && str.startsWith("-Dcoldfusion.classPath")) {
                retString = str.substring(23, str.length());
                continue;
            }
            StringTokenizer stok = new StringTokenizer(str, " ");
            while (stok.hasMoreTokens()) {
                args.add(stok.nextToken());
            }
        }
        return retString;
    }

    public String quoteCFClassPath(String cfcp) {
        StringBuffer newCP = new StringBuffer(100);
        if (cfcp.startsWith("-Dcoldfusion.classPath")) {
            cfcp = cfcp.substring(cfcp.indexOf(61) + 1, cfcp.length());
        }
        StringTokenizer tok = new StringTokenizer(cfcp, ",");
        while (tok.hasMoreElements()) {
            Object str = tok.nextToken();
            if (((String)(str = ((String)str).trim())).indexOf(32) != -1 && ((String)str).indexOf("\"") == -1 && ((String)str).lastIndexOf("\"") == -1) {
                str = "\"" + (String)str + "\"";
            }
            newCP.append((String)str);
            newCP.append(",");
        }
        if (newCP.charAt(newCP.length() - 1) == ',') {
            newCP.deleteCharAt(newCP.length() - 1);
        }
        return newCP.toString();
    }

    private String getJavaArgs() {
        return (String)this.orderedProperties.get("java.args");
    }

    public Map<String, String> getJvmConfigMap() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Optional<String> minJVMHeapSize = this.getOption("-Xms");
        Optional<String> maxJVMHeapSize = this.getOption("-Xmx");
        Optional<String> maxMetaspaceSize = this.getOption("-XX:MaxMetaspaceSize");
        String jvmArguments = this.getJVMArgument(String.valueOf(this.orderedProperties.get("java.args")));
        Optional<String> classPath = this.getOption("-Dcoldfusion.classPath");
        Optional<Object> jdkPath = Optional.ofNullable(this.orderedProperties.get("java.home"));
        map.put(MIN_HEAP_SIZE, "");
        map.put(MAX_HEAP_SIZE, "");
        map.put(MAX_METASPACE_SIZE, "");
        minJVMHeapSize.ifPresent(minHeapSize -> map.put(MIN_HEAP_SIZE, (String)minHeapSize));
        maxJVMHeapSize.ifPresent(maxHeapSize -> map.put(MAX_HEAP_SIZE, (String)maxHeapSize));
        maxMetaspaceSize.ifPresent(maxMetaspace -> map.put(MAX_METASPACE_SIZE, (String)maxMetaspace));
        map.put(JAVA_ARGS, jvmArguments);
        classPath.ifPresent(cp -> map.put(CLASSPATH, (String)cp));
        jdkPath.ifPresent(jdk -> map.put(JDK_PATH, (String)jdk));
        return Collections.unmodifiableMap(map);
    }

    private String getJVMArgument(String javaArgs) {
        List jvmArgumnets = Arrays.stream(javaArgs.split(" ")).filter(StringUtils::isNotBlank).filter(s -> !s.startsWith("-Xms") && !s.startsWith("-Xmx") && !s.startsWith("-XX:MaxMetaspaceSize") && !s.startsWith("-Dcoldfusion.classPath")).collect(Collectors.toList());
        return StringUtils.join(jvmArgumnets, (String)" ");
    }

    private Optional<String> getOption(String s) {
        String javaArgs = this.getJavaArgs();
        int index = javaArgs.indexOf(s);
        if (index < 0) {
            return Optional.empty();
        }
        int separator = javaArgs.indexOf(" ", index);
        String arg = javaArgs.substring(index, separator < 0 ? javaArgs.length() : separator).trim();
        switch (s) {
            case "-Xms": 
            case "-Xmx": {
                return arg.length() > s.length() ? Optional.of(arg.substring(s.length())) : Optional.empty();
            }
            case "-XX:MaxMetaspaceSize": 
            case "-Dcoldfusion.classPath": {
                Object[] keyValue;
                if (!StringUtils.isNotBlank((CharSequence)arg) || (keyValue = arg.split("=")).length <= 1) break;
                keyValue[0] = "";
                return Optional.ofNullable(StringUtils.join((Object[])keyValue));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedProperties getJVMConfig(String jvmConfig) throws IOException {
        FileInputStream fis = null;
        try {
            OrderedProperties props = new OrderedProperties();
            fis = new FileInputStream(jvmConfig);
            props.load(fis);
            OrderedProperties orderedProperties = props;
            return orderedProperties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCFClassPath(String classPath, String jvmConfig) throws FileNotFoundException, IOException {
        ArrayList args = new ArrayList();
        this.getJavaArgsList(jvmConfig, args);
        StringBuffer buf = new StringBuffer(100);
        for (Object obj : args) {
            buf.append(obj);
            buf.append(" ");
        }
        buf.append("-Dcoldfusion.classPath=");
        buf.append(classPath);
        OrderedProperties props = this.getJVMConfig(jvmConfig);
        props.setProperty("java.args", buf.toString());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(jvmConfig);
            props.store(fos);
            fos.close();
        }
    }

    public void saveModifiedMap(Map<String, Object> jvmSettings) {
        Object javaArgs = "-server";
        if (jvmSettings.containsKey(MIN_HEAP_SIZE) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)jvmSettings.get(MIN_HEAP_SIZE)})) {
            javaArgs = (String)javaArgs + " -Xms" + jvmSettings.get(MIN_HEAP_SIZE);
        }
        if (jvmSettings.containsKey(MAX_HEAP_SIZE) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)jvmSettings.get(MAX_HEAP_SIZE)})) {
            javaArgs = (String)javaArgs + " -Xmx" + jvmSettings.get(MAX_HEAP_SIZE) + " ";
        }
        if (jvmSettings.containsKey(MAX_METASPACE_SIZE) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)jvmSettings.get(MAX_METASPACE_SIZE)})) {
            javaArgs = (String)javaArgs + " -XX:MaxMetaspaceSize=" + jvmSettings.get(MAX_METASPACE_SIZE) + " ";
        }
        javaArgs = (String)javaArgs + String.valueOf(jvmSettings.get(JAVA_ARGS)).replace("-server", "") + " -Dcoldfusion.classPath=" + jvmSettings.get(CLASSPATH);
        this.orderedProperties.setProperty("java.args", (String)javaArgs);
        this.orderedProperties.setProperty("java.home", String.valueOf(jvmSettings.get(JDK_PATH)));
        try {
            this.orderedProperties.store(new FileOutputStream(this.jvmFile));
        }
        catch (FileNotFoundException e) {
            logger.error("Error while saving file", (Throwable)e);
            throw new CFSetupException(Messages.getString("errorWhileSavingFile"), e);
        }
    }
}

