/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class LoggingService
extends ServiceBase {
    private ConfigMap settings = null;
    private List<String> disabledForLogging;
    private File file;

    public LoggingService(File loggingConfigXmlFile) {
        this.file = loggingConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading logging settings, ", e);
        }
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.disabledForLogging = (List)v.get(0);
            this.settings = (ConfigMap)v.get(1);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedMap(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.disabledForLogging);
        v.addElement(this.settings);
        this.serialize(v, this.file);
    }
}

