/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MonitoringService
extends ServiceBase {
    private ConfigMap settings;
    private File file;

    public MonitoringService(File monoringConfigFile) {
        this.file = monoringConfigFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading probe settings, ", e);
        }
    }

    public Map getMap() {
        HashMap map = new HashMap();
        map.put("hostname", this.settings.get("hostname"));
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.settings = (ConfigMap)v.get(0);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedMap(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.settings);
        this.serialize(v, this.file);
    }

    public void storeHostName(String name) {
        this.settings.put("hostname", name);
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.settings);
        this.serialize(v, this.file);
    }
}

