/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.ConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.CFSetupConstants;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleLayerSettings {
    private static final Logger logger = LoggerFactory.getLogger(SingleLayerSettings.class);
    private File xmlFile;
    private XMLConfiguration ConfigObject;
    protected Map<String, MapObject> Map;
    private ConfigurationBase settingClass;
    private boolean supressNoSuchKey;

    public boolean isSupressNoSuchKey() {
        return this.supressNoSuchKey;
    }

    public void setSupressNoSuchKey(boolean supressNoSuchKey) {
        this.supressNoSuchKey = supressNoSuchKey;
    }

    public SingleLayerSettings(ConfigurationBase setting) {
        this.settingClass = setting;
        this.Map = new HashMap<String, MapObject>();
        this.xmlFile = this.settingClass.getXMLFileObject();
        this.ConfigObject = setting.getCfg();
    }

    public File getXMLFileObject() {
        return this.settingClass.getXMLFileObject();
    }

    public List<String> getAllXmlAttributes() {
        Set<String> keySet = this.Map.keySet();
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(keySet);
        return keyList;
    }

    public List<String> getValuesforKeys(List<String> keysList) {
        ArrayList<String> valsList = new ArrayList<String>();
        for (String key : keysList) {
            valsList.add(this.Map.get(key).getValue());
        }
        return valsList;
    }

    public String getSetting(String name) {
        MapObject attributeObj = this.Map.get(name);
        if (attributeObj != null) {
            return attributeObj.getValue();
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.settingClass.getCategory(), name)));
        return null;
    }

    public boolean setSetting(String name, String value) {
        File file = this.xmlFile;
        return this.setSetting(name, value, file);
    }

    private boolean setSetting(String name, String value, File file) {
        this.updateMap(name, value);
        return this.setSetting(name, value, file, this.ConfigObject);
    }

    private boolean setSetting(String name, String value, File file, XMLConfiguration xmlConfig) {
        try {
            MapObject node = this.Map.get(name);
            if (node == null) {
                return false;
            }
            String nodePath = node.getNodePath();
            xmlConfig.setProperty(nodePath, (Object)value);
            this.saveWithoutltgt(xmlConfig, file);
        }
        catch (Exception e) {
            logger.error("Exception in setSettings: ", (Throwable)e);
            MessageHandler.getInstance().showError(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public boolean addService(String key, Object val) {
        this.ConfigObject.addProperty(key, val);
        boolean status = this.saveWithoutltgt(this.ConfigObject, this.xmlFile);
        return status;
    }

    public boolean saveWithoutltgt(XMLConfiguration xmlConfig, File settingClassFile) {
        try {
            StringWriter sw = new StringWriter();
            xmlConfig.save((Writer)sw);
            String pojoStr = sw.toString();
            pojoStr = StringEscapeUtils.unescapeXml((String)pojoStr);
            pojoStr = pojoStr.replace("<dummy>", "");
            pojoStr = pojoStr.replace("</dummy>", "");
            Files.write(Paths.get(settingClassFile.getAbsolutePath(), new String[0]), pojoStr.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException | ConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void populateMap(String nodeBase, String totalStruct) {
        int structsLen = 0;
        try {
            structsLen = totalStruct.contains("array[@length]") ? this.ConfigObject.getInt(totalStruct) : this.ConfigObject.getList(totalStruct).size();
        }
        catch (SecurityException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorParsingXML") + this.xmlFile.getAbsolutePath());
        }
        for (int i = 0; i < structsLen; ++i) {
            List structKey = this.ConfigObject.getList(nodeBase + i + ").var.[@name]");
            if (structKey == null) continue;
            int varsInStruct = structKey.size();
            for (int k = 0; k < varsInStruct; ++k) {
                String val;
                String boolInStruct = nodeBase + i + ").var(" + k + ").boolean.[@value]";
                String numInStruct = nodeBase + i + ").var(" + k + ").number";
                String strInStruct = nodeBase + i + ").var(" + k + ").string";
                String boolVarsInStruct = this.ConfigObject.getString(boolInStruct);
                String numberVarsInStruct = this.ConfigObject.getString(numInStruct);
                String stringVarsInStruct = this.ConfigObject.getString(strInStruct);
                String string = boolVarsInStruct == null ? (numberVarsInStruct == null ? (stringVarsInStruct == null ? "" : stringVarsInStruct) : numberVarsInStruct) : (val = boolVarsInStruct);
                String nodePath = boolVarsInStruct == null ? (numberVarsInStruct == null ? (stringVarsInStruct == null ? "" : strInStruct) : numInStruct) : boolInStruct;
                MapObject mapObj = new MapObject(val, nodePath);
                this.Map.put((String)structKey.get(k), mapObj);
                this.settingClass.getMap().put((String)structKey.get(k), val);
            }
            if (this.settingClass.getCategory() != Category.CHART || this.Map.containsKey("CACHEPATH")) continue;
            MapObject mapObj = new MapObject(this.settingClass.getSelectedPath() + CFSetupConstants.DISK_CACHE_LOCATION, "data.array.struct(0).var(0).string");
            this.Map.put("CACHEPATH", mapObj);
            this.settingClass.getMap().put("CACHEPATH", this.settingClass.getSelectedPath() + CFSetupConstants.DISK_CACHE_LOCATION);
        }
    }

    private void updateMap(String key, String newValue) {
        if (!this.Map.containsKey(key)) {
            if (!this.supressNoSuchKey) {
                System.out.println(" No such key exists");
            }
        } else {
            MapObject mapVals = this.Map.get(key);
            mapVals.setValue(newValue);
            this.Map.put(key, mapVals);
            this.settingClass.getMap().put(key, newValue);
        }
    }

    public void show() {
        MessageHandler.getInstance().showWhiteAndBold("{cat} Settings: ".replace("{cat}", StringUtils.capitalize((String)this.settingClass.getCategory().name().toLowerCase())), true);
        if (this.Map == null) {
            return;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (String attrib : this.Map.keySet()) {
            MapObject mapVal = this.Map.get(attrib.toString());
            String userSetting = ProposedSetting.getInstance().getUserDefinedValue(this.settingClass.getCategory(), attrib.toString());
            sortedMap.put(userSetting, mapVal.getValue());
        }
        sortedMap.entrySet().forEach(e -> {
            ValidationDetails vd = SettingValidation.getInstance().getValidationDetail(this.settingClass.getCategory(), ProposedSetting.getInstance().getActualSetting(this.settingClass.getCategory(), (String)e.getKey()));
            if (!vd.isRestricted()) {
                String stringValue = SettingValidation.getInstance().transformToUserValue(this.settingClass.getCategory(), ProposedSetting.getInstance().getActualSetting(this.settingClass.getCategory(), (String)e.getKey()), (String)e.getValue());
                MessageHandler.getInstance().showGreen((String)e.getKey() + " : ", false);
                if (Pattern.matches("[0-9]+\\.0+$", stringValue)) {
                    stringValue = stringValue.split("\\.")[0];
                }
                MessageHandler.getInstance().showInfo(stringValue);
            }
        });
        System.out.println();
    }

    protected Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.Map.forEach((key, value) -> map.put((String)key, value.getValue()));
        return map;
    }
}

