/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.WatchService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class WatchSettings
extends MultiConfigurationBase {
    private String watchXml = Category.WATCH.getFileName();
    private File watchXmlFile;
    private Map<String, Object> watchMap = new HashMap<String, Object>();
    private WatchService watchService;

    public WatchSettings(String instancePath) {
        super(instancePath);
        this.watchXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + this.watchXml);
        this.watchService = new WatchService(this.watchXmlFile);
        this.populateMap();
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.watchMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        return this.updateMap(name, value);
    }

    public boolean updateMap(String name, Object newValue) {
        this.watchMap.put(name, newValue);
        return this.watchService.storeModifiedMap(this.watchMap);
    }

    @Override
    public void populateMap() {
        this.watchMap = new TreeMap<String, Object>(this.watchService.getSettings());
    }

    public Map<String, Object> getMap() {
        return this.watchMap;
    }

    @Override
    public Map<String, ?> getInternalMap() {
        return this.getMap();
    }

    @Override
    public boolean validate(Map<String, Object> keyValue, String service) {
        return true;
    }

    @Override
    public File getXMLFileObject() {
        return this.watchXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.WATCH;
    }
}

