/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.WebSocketService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;

public class WebsocketSettings
extends MultiConfigurationBase {
    private Map<String, Object> websocketMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File websocketXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.WEBSOCKET.getFileName());
    private final WebSocketService service = new WebSocketService(this.websocketXmlFile);

    public WebsocketSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.websocketMap.forEach(map::put);
        return map;
    }

    @Override
    public XMLConfiguration getCfg() {
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.websocketXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.WEBSOCKET;
    }

    @Override
    public void populateMap() {
        this.websocketMap = new HashMap<String, Object>(this.service.getWebsocketSettings());
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.websocketMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        return this.updateMap(name, value);
    }

    public boolean updateMap(String name, Object newValue) {
        this.websocketMap.put(name, newValue);
        return this.service.storeModifiedMap(this.websocketMap);
    }
}

