/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DirectoryValidation
extends ValidationDetails {
    @Override
    public boolean validate(Object value) {
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            return true;
        }
        boolean isValid = true;
        try {
            File f;
            if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                isValid = false;
            }
            if (!(f = new File(String.valueOf(value))).exists() || !f.isDirectory()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        if (!isValid) {
            this.errorMessage = Messages.getString("expectedDirectory");
        }
        return isValid;
    }
}

