/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.validation.RangeValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DoubleValidation
extends ValidationDetails {
    private String validationCriteria;
    private RangeValidation rangeValidation = new RangeValidation();

    @Override
    public boolean validate(Object value) {
        try {
            if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                return true;
            }
            Object obj = Util.getValueByType("double", value);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.validationCriteria})) {
                this.rangeValidation.setValidationCriteria(this.validationCriteria);
                return this.rangeValidation.validate(value);
            }
            return true;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
    }

    public String getValidationCriteria() {
        return this.validationCriteria;
    }

    public void setValidationCriteria(String validationCriteria) {
        this.validationCriteria = validationCriteria;
    }
}

