/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.validation.RangeValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IntValidation
extends ValidationDetails {
    private String validationCriteria;
    private RangeValidation rangeValidation = new RangeValidation();

    @Override
    public boolean validate(Object value) {
        try {
            if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                return true;
            }
            Object obj = Util.getValueByType("int", value);
            if (Objects.isNull(obj)) {
                return false;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.validationCriteria})) {
                this.rangeValidation.setValidationCriteria(this.validationCriteria);
                return this.rangeValidation.validate(value);
            }
            return true;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            this.rangeValidation.setErrorMessage(this.errorMessage);
            return false;
        }
    }

    @Override
    public String getErrorMessage() {
        this.rangeValidation.setErrorMessage(this.errorMessage);
        return StringUtils.isNotBlank((CharSequence)this.validationCriteria) ? this.rangeValidation.getErrorMessage() : "";
    }
}

