/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;

@JsonTypeName(value="MAP")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MapValidation
extends ValidationDetails {
    private Map<Object, Object> validationCriteria;
    private Map<Object, Object> caseInsensitiveValidationCriteria;

    @Override
    public boolean validate(Object value) {
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            return true;
        }
        boolean valid = this.caseInsensitiveValidationCriteria.containsKey(value instanceof String ? ((String)value).toUpperCase() : value);
        return valid;
    }

    public Map<Object, Object> getValidationCriteria() {
        return this.validationCriteria;
    }

    public Map<Object, Object> getCaseInsensitiveValidationCriteria() {
        return this.caseInsensitiveValidationCriteria;
    }

    public void setValidationCriteria(Map<Object, Object> validationCriteria) {
        this.caseInsensitiveValidationCriteria = new HashMap<Object, Object>();
        if (MapUtils.isNotEmpty(validationCriteria)) {
            validationCriteria.forEach((k, v) -> {
                if (k instanceof String) {
                    this.caseInsensitiveValidationCriteria.put(((String)k).toUpperCase(), v);
                } else {
                    this.caseInsensitiveValidationCriteria.put(k, v);
                }
            });
        }
        this.validationCriteria = validationCriteria;
    }

    public void printError(String settingName) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(this.validationCriteria);
        Util.printAllowedValues(settingName, map.keySet());
    }
}

