/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeValidation
extends ValidationDetails {
    @Override
    public boolean validate(Object value) {
        String strValue = String.valueOf(value);
        if (StringUtils.isBlank((CharSequence)strValue)) {
            return true;
        }
        String[] ar = strValue.split(" ");
        boolean isValid = true;
        if (ar.length < 2 || !"AM".equalsIgnoreCase(ar[1]) && !"PM".equalsIgnoreCase(ar[1])) {
            isValid = false;
        }
        ar = ar[0].split(":");
        if (isValid && (ar.length < 2 || ar.length > 3)) {
            isValid = false;
        }
        int hr = 0;
        int min = 0;
        int sec = 0;
        if (isValid &= NumberUtils.isDigits((String)ar[0]) && NumberUtils.isDigits((String)ar[1])) {
            hr = Integer.valueOf(ar[0]);
            min = Integer.valueOf(ar[1]);
        }
        if ((isValid &= 0 < hr && 12 >= hr && 0 <= min && 60 > min) && ar.length == 3) {
            if (isValid &= NumberUtils.isDigits((String)ar[2])) {
                sec = Integer.valueOf(ar[2]);
            }
            isValid &= 0 <= sec && 60 > sec;
        }
        if (!isValid) {
            this.errorMessage = Messages.getString("timeFormatError");
        }
        return isValid;
    }
}

