/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.launcher;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.ConfigurationBase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfigParser {
    File configFile;
    ConfigurationNode ConfigurationNode;
    XMLConfiguration configuration;
    private static final String XML_COMMENT_OPEN = "<!--";
    private static final String XML_COMMENT_CLOSE = "-->";
    private static final Pattern HTTPS_PATTERN = Pattern.compile("Connector.*protocol.*Http11NioProtocol");
    private static final Pattern HTTP_PATTERN = Pattern.compile("Connector.*protocol=\"HTTP/1.1");
    private static final Pattern CERTIFICATE_PATTERN = Pattern.compile("Certificate.*certificateKeystoreFile");
    private static final String CERTIFICATE_LOCATION = "certificateKeystoreFile";
    private static final String CERTIFICATE_PASSWORD = "certificateKeystorePassword";
    private static final String ENABLED_HTTPS = "httpsEnabled";
    private static final String ENABLED_HTTP = "httpEnabled";
    private static final String ALGORITHM = "type";
    private static final String RSA = "RSA";
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigParser.class);

    public ServerConfigParser(String configFileName) {
        this.configFile = new File(configFileName);
        this.parse();
    }

    public void parse() {
        this.configuration = ConfigurationBase.getParsedConfigObject(this.configFile);
        this.ConfigurationNode = this.configuration.getRootNode();
    }

    public boolean hasClusterElement() {
        ConfigurationNode engineNode;
        ConfigurationNode node;
        return this.ConfigurationNode != null && (node = (ConfigurationNode)(engineNode = this.getEngineNode()).getChildren("Cluster").get(0)) != null;
    }

    public String getMultiCastServicePort() {
        ConfigurationNode engineNode = this.getEngineNode();
        if (engineNode != null) {
            try {
                if (engineNode.getChildren("Cluster") != null && ((ConfigurationNode)engineNode.getChildren("Cluster").get(0)).getChildren("Channel") != null && ((ConfigurationNode)((ConfigurationNode)engineNode.getChildren("Cluster").get(0)).getChildren("Channel").get(0)).getChildren("Membership") != null) {
                    ConfigurationNode node = (ConfigurationNode)((ConfigurationNode)((ConfigurationNode)engineNode.getChildren("Cluster").get(0)).getChildren("Channel").get(0)).getChildren("Membership").get(0);
                    return Optional.ofNullable(((ConfigurationNode)node.getAttributes("port").get(0)).getValue().toString()).orElse("");
                }
                return "";
            }
            catch (Exception e) {
                logger.error("Unable to get MultiCastServicePort");
            }
        }
        return "";
    }

    public void setMaxThreads(String maxThreads) {
        if (this.ConfigurationNode != null) {
            for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
                node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("maxThreads", (Object)maxThreads));
            }
            for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Executor")) {
                node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("maxThreads", (Object)maxThreads));
            }
        }
    }

    public int getMaxThreads() {
        if (this.ConfigurationNode != null) {
            try {
                for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
                    List nodeValue = node.getAttributes("maxThreads");
                    if (nodeValue == null || ((ConfigurationNode)nodeValue.get(0)).getValue() == null) continue;
                    return Integer.parseInt(String.valueOf(((ConfigurationNode)nodeValue.get(0)).getValue()));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
        return 0;
    }

    public String getReceiverPort() {
        ConfigurationNode receiverNode;
        ConfigurationNode channelNode;
        ConfigurationNode clusterNode = this.getClusterNode();
        if (clusterNode != null && (channelNode = (ConfigurationNode)clusterNode.getChildren("Channel").get(0)) != null && (receiverNode = (ConfigurationNode)channelNode.getChildren("Receiver").get(0)) != null) {
            Object value = ((ConfigurationNode)receiverNode.getAttributes("port").get(0)).getValue();
            return value == null ? "" : String.valueOf(value);
        }
        return "";
    }

    public void setReceiverPort(String port) {
        ConfigurationNode receiverNode;
        ConfigurationNode channelNode;
        ConfigurationNode clusterNode = this.getClusterNode();
        if (clusterNode != null && (channelNode = (ConfigurationNode)clusterNode.getChildren("Channel").get(0)) != null && (receiverNode = (ConfigurationNode)channelNode.getChildren("Receiver").get(0)) != null) {
            receiverNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
        }
    }

    public void setMultiCastServicePort(String port) {
        ConfigurationNode node = null;
        if (CollectionUtils.isNotEmpty((Collection)this.ConfigurationNode.getChildren("Service")) && CollectionUtils.isNotEmpty((Collection)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine")) && ((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Cluster") != null && ((ConfigurationNode)((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Cluster").get(0)).getChildren("Channel") != null) {
            node = (ConfigurationNode)((ConfigurationNode)((ConfigurationNode)((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Cluster").get(0)).getChildren("Channel").get(0)).getChildren("Membership").get(0);
        }
        if (node != null) {
            node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
        }
    }

    protected File getBackupFileName() {
        File path = this.configFile.getParentFile();
        String name = "server.xml";
        int index = 1;
        while (new File(path, name + "." + index).exists()) {
            ++index;
        }
        return new File(path, name + "." + index);
    }

    public synchronized void store() throws IOException {
        this.configFile.renameTo(this.getBackupFileName());
        FileWriter writer = new FileWriter(this.configFile);
        this.fixAttribute();
        String xmlToStore = this.ConfigurationNode.toString();
        xmlToStore = ServerConfigParser.mergeMultiLines(xmlToStore, "");
        writer.write(xmlToStore);
        writer.close();
    }

    public static String mergeMultiLines(String multiLineText, String replaceWith) {
        return multiLineText.replaceAll("(?m)^\\s*$[\n\r]{1,}", replaceWith);
    }

    protected void fixAttribute() {
        String pattern;
        ConfigurationNode node = null;
        if (this.ConfigurationNode.getChildren("Service") != null && ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine") != null && ((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Host") != null) {
            node = (ConfigurationNode)((ConfigurationNode)((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Host").get(0)).getChildren("Valve").get(0);
        }
        if (node != null && CollectionUtils.isNotEmpty((Collection)node.getAttributes("pattern")) && (pattern = (String)((ConfigurationNode)node.getAttributes("pattern").get(0)).getValue()) != null) {
            pattern = pattern.replaceAll("\"", "&quot;");
            node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("pattern", (Object)pattern));
        }
    }

    public void setShutdownPort(String port) {
        if (this.ConfigurationNode != null) {
            List ports = this.ConfigurationNode.getAttributes("port");
            if (CollectionUtils.isEmpty((Collection)ports)) {
                this.ConfigurationNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
            } else {
                ((ConfigurationNode)ports.get(0)).setValue((Object)port);
            }
        }
    }

    public String getShutDownPort() {
        if (this.ConfigurationNode != null) {
            return ((ConfigurationNode)this.ConfigurationNode.getAttributes("port").get(0)).getValue().toString();
        }
        return null;
    }

    public boolean hasConnectorDefined(boolean internal) {
        Iterator connectorNodes = null;
        if (this.ConfigurationNode.getChildren("Service") != null) {
            connectorNodes = ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector").iterator();
        }
        while (connectorNodes.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)connectorNodes.next();
            String protocol = ((ConfigurationNode)node.getAttributes("protocol").get(0)).getValue().toString();
            if (!(internal ? protocol.toLowerCase().contains("http") : protocol.contains("AJP"))) continue;
            return true;
        }
        return false;
    }

    public void setConnectorPort(String port, boolean internal) {
        if (!this.hasConnectorDefined(internal)) {
            ConfigurationNode serviceNode = (ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0);
            HierarchicalConfiguration.Node connectorNode = new HierarchicalConfiguration.Node("Connector", (Object)serviceNode);
            connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("connectionTimeout", (Object)"20000"));
            connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
            connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("redirectPort", (Object)"8443"));
            if (internal) {
                connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("protocol", (Object)"org.apache.coyote.http11.Http11NioProtocol"));
                connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("executor", (Object)"tomcatThreadPool"));
            } else {
                connectorNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("protocol", (Object)"AJP/1.3"));
            }
        } else {
            for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
                String protocol = ((ConfigurationNode)node.getAttributes("protocol").get(0)).getValue().toString();
                if (internal) {
                    if (!protocol.toLowerCase().contains("http")) continue;
                    node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
                    break;
                }
                if (!protocol.contains("AJP")) continue;
                node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("port", (Object)port));
                break;
            }
        }
    }

    public String getConnectorPort() {
        return this.getConnectorPort(false);
    }

    public String getConnectorPort(boolean internal) {
        for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
            String protocol = ((ConfigurationNode)node.getAttributes("protocol").get(0)).getValue().toString();
            if (!(internal ? protocol.toLowerCase().contains("http") : protocol.contains("AJP"))) continue;
            return ((ConfigurationNode)node.getAttributes("port").get(0)).getValue().toString();
        }
        return "";
    }

    public boolean isSecure(String port) {
        for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
            String secure;
            if (!((ConfigurationNode)node.getAttributes("port").get(0)).getValue().toString().equalsIgnoreCase(port) || (secure = ((ConfigurationNode)node.getAttributes("secure").get(0)).getValue().toString()) == null) continue;
            return Boolean.parseBoolean(secure);
        }
        return false;
    }

    public void setRedirectPort(String port) {
        for (ConfigurationNode node : ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector")) {
            node.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("redirectPort", (Object)port));
        }
    }

    public String getRedirectPort() {
        try {
            Iterator connectorNodes = ((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Connector").iterator();
            if (connectorNodes.hasNext()) {
                ConfigurationNode node = (ConfigurationNode)connectorNodes.next();
                return ((ConfigurationNode)node.getAttributes("redirectPort").get(0)).getValue().toString();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public void addJvmRoute(String jvmRoute) {
        this.getEngineNode().removeAttribute("jvmRoute");
        this.getEngineNode().addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node("jvmRoute", (Object)jvmRoute));
    }

    public String getJvmRoute() {
        if (this.ConfigurationNode != null) {
            return ((ConfigurationNode)this.getEngineNode().getAttributes("jvmRoute").get(0)).getValue().toString();
        }
        return null;
    }

    protected ConfigurationNode getEngineNode() {
        return CollectionUtils.isNotEmpty((Collection)this.ConfigurationNode.getChildren("Service")) && CollectionUtils.isNotEmpty((Collection)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine")) ? (ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0) : null;
    }

    protected ConfigurationNode getClusterNode() {
        return CollectionUtils.isNotEmpty((Collection)this.ConfigurationNode.getChildren("Service")) && CollectionUtils.isNotEmpty((Collection)((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Cluster")) ? (ConfigurationNode)((ConfigurationNode)((ConfigurationNode)this.ConfigurationNode.getChildren("Service").get(0)).getChildren("Engine").get(0)).getChildren("Cluster").get(0) : null;
    }

    public String toString() {
        this.fixAttribute();
        return this.ConfigurationNode.toString();
    }

    public void close() {
        this.ConfigurationNode = null;
    }

    public boolean saveXml() {
        try {
            this.configuration.save();
        }
        catch (ConfigurationException e) {
            MessageHandler.getInstance().showError(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public Map<String, Object> getProtocolConnector(String protocolName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List configurationNodes = this.configuration.getRoot().getChildren("Service");
        if (CollectionUtils.isNotEmpty((Collection)configurationNodes)) {
            Optional<ConfigurationNode> optionalServiceNode = configurationNodes.stream().filter(configurationNode -> {
                List names = configurationNode.getAttributes("name");
                return CollectionUtils.isNotEmpty((Collection)names) && "Catalina".equals(((ConfigurationNode)names.get(0)).getValue());
            }).findFirst();
            optionalServiceNode.ifPresent(serviceNode -> {
                List connectors = serviceNode.getChildren("Connector");
                if (CollectionUtils.isNotEmpty((Collection)connectors)) {
                    Optional<ConfigurationNode> optionalHttpNode = connectors.stream().filter(configurationNode -> {
                        List protocols = configurationNode.getAttributes("protocol");
                        return CollectionUtils.isNotEmpty((Collection)protocols) && protocolName.equals(((ConfigurationNode)protocols.get(0)).getValue());
                    }).findFirst();
                    optionalHttpNode.ifPresent(httpNode -> {
                        for (ConfigurationNode configurationNode : httpNode.getAttributes()) {
                            map.put(configurationNode.getName(), configurationNode.getValue());
                        }
                    });
                }
            });
        }
        return map;
    }

    public void setProtocolConnector(String protocolName, Map<String, Object> map) {
        List configurationNodes = this.configuration.getRoot().getChildren("Service");
        if (CollectionUtils.isNotEmpty((Collection)configurationNodes)) {
            Optional<ConfigurationNode> optionalServiceNode = configurationNodes.stream().filter(configurationNode -> {
                List names = configurationNode.getAttributes("name");
                return CollectionUtils.isNotEmpty((Collection)names) && "Catalina".equals(((ConfigurationNode)names.get(0)).getValue());
            }).findFirst();
            optionalServiceNode.ifPresent(serviceNode -> {
                List connectors = serviceNode.getChildren("Connector");
                if (CollectionUtils.isNotEmpty((Collection)connectors)) {
                    Optional<ConfigurationNode> optionalHttpNode = connectors.stream().filter(configurationNode -> {
                        List protocols = configurationNode.getAttributes("protocol");
                        return CollectionUtils.isNotEmpty((Collection)protocols) && protocolName.equals(((ConfigurationNode)protocols.get(0)).getValue());
                    }).findFirst();
                    optionalHttpNode.ifPresent(httpNode -> {
                        httpNode.removeAttributes();
                        map.forEach((key, value) -> httpNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node(key, value)));
                    });
                }
            });
        }
    }

    public Map<String, Object> getHttps() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List configurationNodes = this.configuration.getRoot().getChildren("Service");
        if (CollectionUtils.isNotEmpty((Collection)configurationNodes)) {
            Optional<ConfigurationNode> optionalServiceNode = configurationNodes.stream().filter(configurationNode -> {
                List names = configurationNode.getAttributes("name");
                return CollectionUtils.isNotEmpty((Collection)names) && "Catalina".equals(((ConfigurationNode)names.get(0)).getValue());
            }).findFirst();
            optionalServiceNode.ifPresent(serviceNode -> {
                List connectors = serviceNode.getChildren("Connector");
                if (CollectionUtils.isNotEmpty((Collection)connectors)) {
                    Optional<ConfigurationNode> optionalHttpNode = connectors.stream().filter(configurationNode -> {
                        List schemes = configurationNode.getAttributes("scheme");
                        return CollectionUtils.isNotEmpty((Collection)schemes) && "https".equals(((ConfigurationNode)schemes.get(0)).getValue());
                    }).findFirst();
                    optionalHttpNode.ifPresent(httpNode -> {
                        for (ConfigurationNode configurationNode : httpNode.getAttributes()) {
                            map.put(configurationNode.getName(), configurationNode.getValue());
                        }
                    });
                }
            });
        }
        return map;
    }

    public Map<String, Object> getSSlConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List configurationNodes = this.configuration.getRoot().getChildren("Service");
        if (CollectionUtils.isNotEmpty((Collection)configurationNodes)) {
            Optional<ConfigurationNode> optionalServiceNode = configurationNodes.stream().filter(configurationNode -> {
                List names = configurationNode.getAttributes("name");
                return CollectionUtils.isNotEmpty((Collection)names) && "Catalina".equals(((ConfigurationNode)names.get(0)).getValue());
            }).findFirst();
            optionalServiceNode.ifPresent(serviceNode -> {
                List connectors = serviceNode.getChildren("Connector");
                if (CollectionUtils.isNotEmpty((Collection)connectors)) {
                    Optional<ConfigurationNode> optionalHttpNode = connectors.stream().filter(configurationNode -> {
                        List schemes = configurationNode.getAttributes("scheme");
                        return CollectionUtils.isNotEmpty((Collection)schemes) && "https".equals(((ConfigurationNode)schemes.get(0)).getValue());
                    }).findFirst();
                    optionalHttpNode.ifPresent(httpNode -> {
                        List sslHostConfigs = httpNode.getChildren("SSLHostConfig");
                        if (CollectionUtils.isNotEmpty((Collection)sslHostConfigs)) {
                            Optional optionalSslHostConfig = sslHostConfigs.stream().findFirst();
                            optionalSslHostConfig.ifPresent(sslHostConfig -> {
                                List certificates = sslHostConfig.getChildren("Certificate");
                                if (CollectionUtils.isNotEmpty((Collection)certificates)) {
                                    Optional optionalCertificate = certificates.stream().findFirst();
                                    optionalCertificate.ifPresent(certificate -> {
                                        for (ConfigurationNode certAttribute : certificate.getAttributes()) {
                                            if (!CERTIFICATE_LOCATION.equals(certAttribute.getName()) && !CERTIFICATE_PASSWORD.equals(certAttribute.getName()) && !ALGORITHM.equals(certAttribute.getName())) continue;
                                            map.put(certAttribute.getName(), certAttribute.getValue());
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }
        map.put(ENABLED_HTTPS, false);
        map.put(ENABLED_HTTP, false);
        map.putIfAbsent(CERTIFICATE_LOCATION, "");
        map.putIfAbsent(CERTIFICATE_PASSWORD, "");
        map.putIfAbsent(ALGORITHM, RSA);
        return map;
    }

    public void setHttps(Map<String, Object> map) {
        List configurationNodes = this.configuration.getRoot().getChildren("Service");
        if (CollectionUtils.isNotEmpty((Collection)configurationNodes)) {
            Optional<ConfigurationNode> optionalServiceNode = configurationNodes.stream().filter(configurationNode -> {
                List names = configurationNode.getAttributes("name");
                return CollectionUtils.isNotEmpty((Collection)names) && "Catalina".equals(((ConfigurationNode)names.get(0)).getValue());
            }).findFirst();
            optionalServiceNode.ifPresent(serviceNode -> {
                List connectors = serviceNode.getChildren("Connector");
                if (CollectionUtils.isNotEmpty((Collection)connectors)) {
                    Optional<ConfigurationNode> optionalHttpNode = connectors.stream().filter(configurationNode -> {
                        List schemes = configurationNode.getAttributes("scheme");
                        return CollectionUtils.isNotEmpty((Collection)schemes) && "https".equals(((ConfigurationNode)schemes.get(0)).getValue());
                    }).findFirst();
                    optionalHttpNode.ifPresent(httpNode -> map.forEach((key, value) -> {
                        httpNode.removeAttribute(key);
                        httpNode.addAttribute((ConfigurationNode)new HierarchicalConfiguration.Node(key, value));
                    }));
                }
            });
        }
    }

    private int getBackupFileIndex(String fileName) {
        int index = 1;
        while (new File(fileName + "." + index).exists()) {
            ++index;
        }
        return index;
    }

    private boolean isPortAvailable(final int portNum) {
        if (System.getSecurityManager() == null) {
            return this.isPortAvailableHelper(portNum);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return ServerConfigParser.this.isPortAvailableHelper(portNum);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortAvailableHelper(int port) {
        boolean available = false;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }

    /*
     * WARNING - void declaration
     */
    public void updateServerSslFile(String fileName, String certificatePath, String certificatePassword, String certificateAlgorithm, boolean enableHttps, boolean enableHttp) throws IOException {
        ArrayList<Object> newLines = new ArrayList<Object>();
        for (String string : Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8)) {
            if (HTTPS_PATTERN.matcher(string).find()) {
                void var9_16;
                if (enableHttps) {
                    void var9_13;
                    if (string.contains(XML_COMMENT_OPEN)) {
                        String string2 = string.replace(XML_COMMENT_OPEN, "");
                    }
                    int httpsPort = 8443;
                    while (!this.isPortAvailable(httpsPort)) {
                        ++httpsPort;
                    }
                    String string3 = var9_13.replaceAll("port=\"\\d+\"", "port=\"" + httpsPort + "\"");
                } else if (!string.contains(XML_COMMENT_OPEN)) {
                    String string4 = XML_COMMENT_OPEN + string;
                }
                newLines.add(var9_16);
                continue;
            }
            if (CERTIFICATE_PATTERN.matcher(string).find()) {
                newLines.add("<Certificate certificateKeystoreFile=\"" + certificatePath + "\" certificateKeystorePassword=\"" + certificatePassword + "\" type=\"" + certificateAlgorithm + "\" />");
                continue;
            }
            if (string.contains("</Connector>")) {
                void var9_19;
                if (enableHttps) {
                    String string5 = string.replace(XML_COMMENT_CLOSE, "");
                } else if (!string.contains(XML_COMMENT_CLOSE)) {
                    String string6 = string + XML_COMMENT_CLOSE;
                }
                newLines.add(var9_19);
                continue;
            }
            if (HTTP_PATTERN.matcher(string).find()) {
                void var9_23;
                if (enableHttp) {
                    String string7 = string.replace(XML_COMMENT_OPEN, "").replace(XML_COMMENT_CLOSE, "");
                } else if (!string.contains(XML_COMMENT_OPEN)) {
                    String string9 = XML_COMMENT_OPEN + string;
                    string9 = string9.replace("/>", "/>-->");
                }
                newLines.add(var9_23);
                continue;
            }
            newLines.add(string);
        }
        int backupIndex = this.getBackupFileIndex(fileName);
        Files.copy(Paths.get(fileName, new String[0]), Paths.get(fileName + "." + backupIndex, new String[0]), new CopyOption[0]);
        Files.write(Paths.get(fileName, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

