/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.lambda;

import com.adobe.coldfusion.lambda.Arguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static final String basePath = System.getProperty("CFUSION_HOME") + File.separator + "..";
    public static final String defaultArchiveName = "cf-aws-serverless.zip";
    public static final String defaultArchiveFolder = basePath + File.separator + "cfusion" + File.separator + "bin" + File.separator + "dist";
    public static final String defaultArchivePath = defaultArchiveFolder + File.separator + "cf-aws-serverless.zip";
    public static final String[] excludeList = new String[]{"config", "cfusion" + File.separator + "bin", "cfusion" + File.separator + "logs", "template.yaml"};
    public static final String[] excludeLibs = new String[]{"cf-lambdazip.jar", "cf-osgicli.jar", "cf-startup.jar", "jansi-1.18.jar", "jline-3.13.1.jar", "picocli-4.0.4.jar", "picocli-shell-jline3-4.0.4.jar", "wsproxyconfig.jar"};
    private static final long MAX_SIZE = 0xFA00000L;
    private static String LICENSE_URL = "https://coldfusion.adobe.io/claus/v1/";
    private static final String ACTIVATION_ENDPOINT = "activateLambda";
    private static int fileSize = 0;
    private static File outputFile = null;
    private static List<File> zippedFiles = new ArrayList<File>();
    private static List<File> skippedFiles = new ArrayList<File>();
    private static Arguments initArgs;

    public static void createArchive(Arguments args) {
        initArgs = args;
        ZipUtil.createDestFile(args.getZipDir());
        boolean zipComplete = ZipUtil.createZipFile();
        if (zipComplete) {
            ZipUtil.writeToLogs();
        }
    }

    private static void writeToLogs() {
        String path = defaultArchiveFolder + File.separator + ".." + File.separator + "ziplog-" + LocalDateTime.now().toString().replace(':', '-') + ".log";
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("Skipped Files:\n\n\n");
            for (File f : skippedFiles) {
                if (f.isDirectory()) {
                    buffer.append("Directory: " + f.getCanonicalPath() + "\n");
                    continue;
                }
                buffer.append("File: " + f.getCanonicalPath() + "\n");
            }
            buffer.append("\n\n\nZipped Files:\n\n\n");
            for (File f : zippedFiles) {
                buffer.append("File: " + f.getCanonicalPath() + "\n");
            }
            try {
                Files.write(Paths.get(path, new String[0]), buffer.toString().getBytes(), new OpenOption[0]);
                System.out.println("Log file: " + new File(path).getCanonicalPath());
            }
            catch (IOException e) {
                System.err.println("Error while creating file: " + new File(path).getCanonicalPath());
            }
        }
        catch (Exception e) {
            System.out.println("Error while writing log file");
            e.printStackTrace();
        }
    }

    private static void createDestFile(String dest) {
        Object filename;
        if (dest == null) {
            dest = defaultArchivePath;
        }
        if (!((String)(filename = dest)).endsWith(".zip")) {
            filename = (String)filename + File.separator + defaultArchiveName;
        }
        try {
            if (!new File(dest).exists()) {
                new File(dest).mkdirs();
            }
            outputFile = new File((String)filename);
        }
        catch (Exception e) {
            System.err.println("Error while accessing:" + (String)filename);
            e.printStackTrace();
            outputFile = new File(defaultArchivePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createZipFile() {
        boolean zipDone = false;
        System.out.println("Creating AWS Lambda deployment package...");
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File outputDir = null;
        File tempDirFile = null;
        try {
            File[] files;
            outputDir = outputFile;
            tempDirFile = new File(basePath);
            if (!outputDir.getParentFile().exists()) {
                outputDir.getParentFile().mkdirs();
            }
            if (outputDir.exists()) {
                outputDir.delete();
            }
            fos = new FileOutputStream(outputDir);
            zos = new ZipOutputStream(fos);
            for (File f : files = tempDirFile.listFiles()) {
                if (ZipUtil.checkExcludeCondition(f)) continue;
                ZipUtil.performZip(f, f.getName(), zos);
            }
            zipDone = true;
        }
        catch (FileNotFoundException e) {
            System.err.println("Error while creating the package:" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Error while accessing the file:" + e.getMessage());
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                    if ((long)fileSize > 0xFA00000L) {
                        System.out.println("Size of unzipped package is greater than 250MB and cannot be uploaded to AWS.");
                    }
                    System.out.println("Zip file created at " + outputFile.getCanonicalPath());
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return zipDone;
    }

    private static boolean checkExcludeCondition(File f) {
        try {
            if (f.isDirectory()) {
                for (String directory : excludeList) {
                    String completePath = basePath + File.separator + directory;
                    if (!new File(completePath).exists() || !new File(completePath).getCanonicalPath().equals(f.getCanonicalPath())) continue;
                    return true;
                }
            } else if (f.exists()) {
                File parent = f.getParentFile();
                Object path = parent.getCanonicalPath();
                for (String file : excludeList) {
                    String completePath = basePath + File.separator + file;
                    if (!f.getCanonicalPath().equals(new File(completePath).getCanonicalPath())) continue;
                    return true;
                }
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                if (((String)path).endsWith(File.separator + "lib" + File.separator)) {
                    for (String jar : excludeLibs) {
                        if (!f.getCanonicalPath().equals(new File((String)path + jar).getCanonicalPath())) continue;
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private static void performZip(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                if (!ZipUtil.checkExcludeCondition(childFile)) {
                    ZipUtil.performZip(childFile, fileName + "/" + childFile.getName(), zipOut);
                    continue;
                }
                skippedFiles.add(childFile);
            }
            return;
        }
        if (!ZipUtil.checkExcludeCondition(fileToZip)) {
            int length;
            zippedFiles.add(fileToZip);
            fileSize = (int)((long)fileSize + fileToZip.length());
            FileInputStream fis = new FileInputStream(fileToZip);
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            fis.close();
        } else {
            skippedFiles.add(fileToZip);
        }
    }

    static {
        String licenseUrl = System.getenv("licenseurl");
        if (licenseUrl != null) {
            LICENSE_URL = licenseUrl;
        }
    }
}

