/*
 * Decompiled with CFR 0.152.
 */
package coldfusion;

import coldfusion.ConfigMapListener;
import coldfusion.Service;
import coldfusion.server.ConfigMap;
import coldfusion.server.ParsingConfigFileException;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceListener;
import coldfusion.server.ServiceMetaData;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.WritingConfigFileException;
import coldfusion.util.FileLock;
import coldfusion.util.IOUtils;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxDeserializer;
import coldfusion.wddx.WddxSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ServiceBase
implements Service,
ConfigMapListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map rb;
    private long lastmodified;
    protected boolean enableWatch;
    private List watchFileList;
    protected List serviceListners;
    protected static final boolean isFiddleEnabled = Boolean.parseBoolean(System.getProperty("coldfusion.fiddle.enable", "false"));

    @Override
    public void start() throws ServiceException {
        try {
            this.load();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() throws ServiceException {
    }

    @Override
    public void restart() throws ServiceException {
        this.stop();
        this.start();
    }

    @Override
    public int getStatus() {
        return 4;
    }

    public void load() throws ServiceException {
    }

    public void store() throws ServiceException {
    }

    public final Object deserialize(final File path) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceBase.this.doDeserialize(path);
            }
        });
    }

    private synchronized Object doDeserialize(File file) {
        boolean doLock = this.checkLock();
        FileLock lock = new FileLock(file.getParent(), file.getName());
        try {
            if (doLock) {
                lock.obtain();
            }
            WddxDeserializer deserializer = new WddxDeserializer();
            InputSource source = new InputSource(new FileReader(file));
            Object object = deserializer.deserialize(source);
            return object;
        }
        catch (Exception ex) {
            Object name = file.getName();
            if (((String)name).startsWith("neo-")) {
                int index;
                File path = file.getParentFile();
                File backup = new File(path, (String)(name = ((String)name).substring(0, index = ((String)name).lastIndexOf(".xml")) + ".bak"));
                if (backup.exists() && backup.length() > 0L) {
                    file.delete();
                    backup.renameTo(file);
                    if (this.logger != null) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                    } else {
                        ex.printStackTrace();
                    }
                    try {
                        WddxDeserializer deserializer = new WddxDeserializer();
                        InputSource source = new InputSource(new FileReader(file));
                        Object object = deserializer.deserialize(source);
                        return object;
                    }
                    catch (Exception e) {
                        throw new ParsingConfigFileException(file.getAbsolutePath(), e);
                    }
                }
                throw new ParsingConfigFileException(file.getAbsolutePath(), ex);
            }
            throw new ParsingConfigFileException(file.getAbsolutePath(), ex);
        }
        finally {
            if (doLock) {
                lock.release();
            }
        }
    }

    private boolean checkLock() {
        return false;
    }

    public final String serialize(Object obj) {
        try {
            WddxSerializer ws = new WddxSerializer();
            StringWriter sw = new StringWriter();
            ws.serialize(obj, sw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public final void serialize(final Object obj, final File file) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceBase.this.doSerialize(obj, file);
                return null;
            }
        });
    }

    private synchronized void doSerialize(Object obj, File file) {
        FileWriter fwriter = null;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new ServiceRuntimeException(ex);
        }
        File path = file.getParentFile();
        String name = file.getName();
        boolean doLock = this.checkLock();
        FileLock lock = new FileLock(file.getParent(), name);
        if (isFiddleEnabled && name.equals("neo-security.xml")) {
            return;
        }
        try {
            if (doLock) {
                lock.obtain();
            }
            int index = name.lastIndexOf(".xml");
            String backupfilename = name.substring(0, index) + ".bak";
            File backup = new File(path, backupfilename);
            if (file.length() > 0L) {
                IOUtils.copyFile(file, backup);
            }
            BufferedWriter out = null;
            try {
                fwriter = new FileWriter(file, false);
                out = new BufferedWriter(fwriter);
                String data = this.serialize(obj);
                if (data == null || data.length() == 0) {
                    throw new WritingConfigFileException(file.getAbsolutePath());
                }
                out.write(data);
                out.flush();
            }
            catch (Throwable ex) {
                if (backup.length() > 0L) {
                    IOUtils.copyFile(backup, file);
                }
                this.lastmodified = backup.lastModified();
                throw new ServiceRuntimeException(ex);
            }
            finally {
                if (out != null) {
                    out.close();
                    this.lastmodified = file.lastModified();
                }
                if (fwriter != null) {
                    fwriter.close();
                }
            }
        }
        catch (IOException e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            if (doLock) {
                lock.release();
            }
        }
    }

    protected String getLoggerName() {
        return "coldfusion.server";
    }

    protected final boolean info(String s) {
        if (this.logger != null) {
            this.logger.info(s);
        } else {
            System.out.println(s);
        }
        return true;
    }

    public Object deserialize(InputStream is) throws WddxDeserializationException, ParserConfigurationException, SAXException, IOException {
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = new InputSource(is);
        return deserializer.deserialize(source);
    }

    protected final boolean warning(String s) {
        if (this.logger != null) {
            this.logger.warn(s);
        } else {
            System.out.println(s);
        }
        return true;
    }

    protected final boolean debug(String s) {
        if (this.logger != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(s);
            }
        } else {
            System.out.println(s);
        }
        return true;
    }

    @Override
    public void mapModified() {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value) {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    protected void initMap(ConfigMap map, String str) {
        for (ConfigMap m : map.values()) {
            m.init(this, str);
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
        }
        return this.rb;
    }

    @Override
    public ServiceMetaData getMetaData() {
        return new ServiceBaseMetaData();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public void setEnableWatch(boolean enableWatch) {
        this.enableWatch = enableWatch;
    }

    public void setWatchFile(File file) {
        if (this.watchFileList == null) {
            this.watchFileList = new ArrayList();
        }
        this.watchFileList.add(file);
    }

    public void filesModified(List l) {
        for (File modifiedFile : l) {
            if (modifiedFile.lastModified() <= this.getLastModified()) continue;
            if (this.logger != null) {
                this.logger.info(modifiedFile.getName() + "  has been modified . Reloading the service " + this);
            }
            try {
                this.load();
            }
            catch (ServiceException e) {
                if (this.logger == null) continue;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isInterested(File modifiedFile) {
        boolean condition = false;
        Iterator itr = this.watchFileList.iterator();
        while (itr.hasNext() && !(condition = modifiedFile.getName().equalsIgnoreCase(((File)itr.next()).getName()))) {
        }
        return condition;
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        if (this.serviceListners == null) {
            this.serviceListners = new ArrayList();
        }
        this.serviceListners.add(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        if (this.serviceListners != null) {
            this.serviceListners.remove(listener);
        }
    }

    protected void notifyServiceListeners() {
        if (this.serviceListners == null) {
            return;
        }
        for (int i = 0; i < this.serviceListners.size(); ++i) {
            ServiceListener listener = (ServiceListener)this.serviceListners.get(i);
            listener.serviceModified();
        }
    }

    public class ServiceBaseMetaData
    implements ServiceMetaData {
        @Override
        public int getPropertyCount() {
            return 0;
        }

        @Override
        public String getPropertyLabel(int index) {
            return null;
        }

        @Override
        public String getPropertyType(int index) {
            return null;
        }

        @Override
        public boolean exists(String name) {
            return false;
        }
    }
}

