/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud;

import coldfusion.cloud.CloudVendorName;
import java.util.stream.Stream;

public enum CloudServiceName {
    S3(CloudVendorName.AWS),
    SQS(CloudVendorName.AWS),
    SNS(CloudVendorName.AWS),
    DYNAMODB(CloudVendorName.AWS),
    AZURE_BLOB(CloudVendorName.AZURE),
    SERVICE_BUS(CloudVendorName.AZURE),
    FIRESTORE(CloudVendorName.GCP),
    PUBSUB(CloudVendorName.GCP),
    STORAGE(CloudVendorName.GCP);

    private CloudVendorName vendorName;

    private CloudServiceName(CloudVendorName vendorName) {
        this.vendorName = vendorName;
    }

    boolean isValidVendor(CloudVendorName vendorName) {
        return this.vendorName == vendorName;
    }

    public static CloudServiceName fromName(String name) {
        return Stream.of(CloudServiceName.values()).filter(c -> c.name().equals(name)).findFirst().orElse(null);
    }
}

