/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud;

import coldfusion.ServiceBase;
import coldfusion.cloud.CloudVendorName;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.azure.AzureCredential;
import coldfusion.cloud.azure.ServiceBusKeyBasedCredential;
import coldfusion.cloud.azure.ServiceBusTokenBasedCredential;
import coldfusion.cloud.consumer.AWSCredentialConsumer;
import coldfusion.cloud.consumer.AzureCredentialConsumer;
import coldfusion.cloud.consumer.GCPCredentialConsumer;
import coldfusion.cloud.consumer.ServiceBusKeyBasedCredentialConsumer;
import coldfusion.cloud.consumer.ServiceBusTokenBasedCredentialConsumer;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.util.RB;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VendorCredentialService
extends ServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(VendorCredentialService.class);
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private File vendorCredentialFile;
    private ConfigMap credentialSetting;

    public VendorCredentialService(File vendorCredentialFile) {
        this.vendorCredentialFile = vendorCredentialFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading VendorCredentialService, ", e);
        }
    }

    public void addCredentialsData(Map map) {
        Struct struct = new Struct();
        struct.putAll(map);
        this.transform(struct);
        if (this.credentialSetting.containsKey(struct.get("alias"))) {
            throw new ValidationException(struct.get("alias") + " CREDENTIAL_ALIAS already exists.");
        }
        this.credentialSetting.put(struct.get("alias"), struct);
        this.store();
    }

    public ConfigMap getAllCredentialsData() {
        return this.credentialSetting;
    }

    public void deleteCredentialsData(String CREDENTIAL_ALIAS) {
        if (!this.credentialSetting.containsKey(CREDENTIAL_ALIAS)) {
            throw new ValidationException(CREDENTIAL_ALIAS + " : not found in vendorCredentials.");
        }
        this.credentialSetting.remove(CREDENTIAL_ALIAS);
        this.store();
    }

    public void modifyCredentialsData(String oldCREDENTIAL_ALIAS, Map map) {
        Struct struct = new Struct();
        struct.putAll(map);
        if (Objects.isNull(oldCREDENTIAL_ALIAS)) {
            throw new ValidationException("oldCREDENTIAL_ALIAS is null.");
        }
        if (!this.credentialSetting.containsKey(oldCREDENTIAL_ALIAS)) {
            throw new ValidationException("oldCREDENTIAL_ALIAS : " + oldCREDENTIAL_ALIAS + " is not present.");
        }
        this.transform(struct);
        this.credentialSetting.remove(oldCREDENTIAL_ALIAS);
        this.credentialSetting.put(struct.get("alias"), struct);
        this.store();
    }

    @Override
    public void start() throws ServiceException {
        super.start();
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.credentialSetting = (ConfigMap)this.deserialize(this.vendorCredentialFile);
            if (this.credentialSetting == null) {
                this.credentialSetting = new ConfigMap(this, "cloudConfig");
            }
        }
        catch (Exception e) {
            logger.error("Error while starting vendor credential service " + e.getMessage(), (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Override
    public void store() {
        this.serialize(this.credentialSetting, this.vendorCredentialFile);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("cloudConfig.formats", "coldfusion.server.MapFormatter");
            this.rb.put("cloudConfig.value", "");
        }
        return this.rb;
    }

    private VendorCredential transform(Struct struct) {
        CloudVendorName vendorName;
        if (struct.isEmpty()) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "emptyCloudCredentialStruct"));
        }
        try {
            vendorName = CloudVendorName.valueOf(FieldTypecastUtil.INSTANCE.getStringProperty(struct.get("vendorName")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, "invalidCloudVendorName"));
        }
        switch (vendorName) {
            case AWS: {
                AWSCredential awsCredential = new AWSCredential();
                this.filler.fillObject(awsCredential, struct, new AWSCredentialConsumer());
                return awsCredential;
            }
            case AZURE: {
                int fieldCount = struct.keySet().size();
                switch (fieldCount) {
                    case 5: {
                        ServiceBusTokenBasedCredential tokenBasedCredential = new ServiceBusTokenBasedCredential();
                        this.filler.fillObject(tokenBasedCredential, struct, new ServiceBusTokenBasedCredentialConsumer());
                        return tokenBasedCredential;
                    }
                    case 6: {
                        ServiceBusKeyBasedCredential keyBasedCredential = new ServiceBusKeyBasedCredential();
                        this.filler.fillObject(keyBasedCredential, struct, new ServiceBusKeyBasedCredentialConsumer());
                        return keyBasedCredential;
                    }
                }
                AzureCredential azureCredential = new AzureCredential();
                this.filler.fillObject(azureCredential, struct, new AzureCredentialConsumer());
                return azureCredential;
            }
            case GCP: {
                GCPCredential gcpCredential = new GCPCredential();
                this.filler.fillObject(gcpCredential, struct, new GCPCredentialConsumer());
                return gcpCredential;
            }
        }
        throw new ValidationException(vendorName.name() + " : is not configured with VendorCredentialService");
    }

    public class CredentialDoesNotExistException
    extends ApplicationException {
        public String credentialCREDENTIAL_ALIAS;

        public CredentialDoesNotExistException(String credCREDENTIAL_ALIAS) {
            this.credentialCREDENTIAL_ALIAS = credCREDENTIAL_ALIAS;
        }
    }
}

