/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.config;

import coldfusion.ServiceBase;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.consumer.BlobCloudConfigConsumer;
import coldfusion.cloud.consumer.S3ServiceConfigConsumer;
import coldfusion.cloud.consumer.metadata.DynamoDBServiceConfigMetadata;
import coldfusion.cloud.consumer.metadata.FirestoreConfigConsumer;
import coldfusion.cloud.consumer.metadata.PubSubConfigConsumer;
import coldfusion.cloud.consumer.metadata.SBConfigMetadata;
import coldfusion.cloud.consumer.metadata.SNSServiceConfigMetadata;
import coldfusion.cloud.consumer.metadata.SQSServiceConfigMetadata;
import coldfusion.cloud.consumer.metadata.StorageConfigConsumer;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.util.RB;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CloudConfigService
extends ServiceBase {
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private File cloudConfigFile;
    private ConfigMap configSetting;
    private static final String ALIAS = "alias";

    public CloudConfigService(File cloudConfigFile) {
        this.cloudConfigFile = cloudConfigFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading CloudConfigService, ", e);
        }
    }

    public boolean addConfigData(Map map) {
        Struct struct = new Struct();
        struct.putAll(map);
        if (!struct.containsKey("serviceName")) {
            throw new RuntimeException("serviceName field not present");
        }
        this.transformToCloudConfig(struct);
        if (this.configSetting.containsKey(struct.get(ALIAS))) {
            throw new ValidationException(struct.containsKey("serviceName") + " alias already exists.");
        }
        this.configSetting.put(struct.get(ALIAS), struct);
        this.store();
        return true;
    }

    public ConfigMap getAllConfigData() {
        return this.configSetting;
    }

    public void deleteConfigData(String alias) {
        if (!this.configSetting.containsKey(alias)) {
            throw new ValidationException(alias + " : not found in cloudConfig.");
        }
        this.configSetting.remove(alias);
        this.store();
    }

    public Struct getConfigData(String alias) {
        Map map = (Map)this.configSetting.get(alias);
        if (map == null) {
            throw new ConfigDoesNotExistException(alias);
        }
        Struct struct = new Struct();
        struct.putAll(map);
        return struct;
    }

    public void modifyConfigData(String oldAlias, Map map) {
        Struct struct = new Struct();
        struct.putAll(map);
        if (Objects.isNull(oldAlias)) {
            throw new ValidationException("oldAlias is null.");
        }
        if (Objects.isNull(struct)) {
            throw new ValidationException("config struct is null");
        }
        if (!this.configSetting.containsKey(oldAlias)) {
            throw new ValidationException("oldAlias : " + oldAlias + " is not present.");
        }
        this.transformToCloudConfig(struct);
        this.configSetting.put(oldAlias, struct);
        this.store();
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.configSetting = (ConfigMap)this.deserialize(this.cloudConfigFile);
            if (this.configSetting == null) {
                this.configSetting = new ConfigMap(this, "cloudConfig");
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("cloudConfig.formats", "coldfusion.server.MapFormatter");
            this.rb.put("cloudConfig.value", "");
        }
        return this.rb;
    }

    @Override
    public void store() {
        this.serialize(this.configSetting, this.cloudConfigFile);
    }

    public void transformToCloudConfig(Map struct) {
        CloudServiceName serviceName;
        if (struct.isEmpty()) {
            throw new ValidationException(RB.getString(CloudConfigService.class, "emptyCloudConfigStruct"));
        }
        try {
            serviceName = CloudServiceName.valueOf(FieldTypecastUtil.INSTANCE.getStringProperty(struct.get("serviceName")).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException(RB.getString(CloudConfigService.class, "invalidServiceName"));
        }
        try {
            switch (serviceName) {
                case S3: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, new S3ServiceConfigConsumer());
                    break;
                }
                case SNS: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, SNSServiceConfigMetadata.getInstance().getConsumerMap());
                    break;
                }
                case SQS: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, SQSServiceConfigMetadata.getInstance().getConsumerMap());
                    break;
                }
                case DYNAMODB: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, DynamoDBServiceConfigMetadata.getInstance().getConsumerMap());
                    break;
                }
                case SERVICE_BUS: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, SBConfigMetadata.getInstance().getConsumerMap());
                    break;
                }
                case AZURE_BLOB: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, BlobCloudConfigConsumer.getInstance());
                    break;
                }
                case FIRESTORE: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, FirestoreConfigConsumer.getInstance());
                    break;
                }
                case PUBSUB: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, PubSubConfigConsumer.getInstance());
                    break;
                }
                case STORAGE: {
                    ValidatorFiller.INSTANCE.fillObject(null, struct, StorageConfigConsumer.getInstance());
                    break;
                }
                default: {
                    throw new ValidationException(serviceName.name() + " : is not configured with CloudCofigService");
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException("Invalid Cloud Service Name. Allowed values : S3, SNS, SQS, DYNAMODB, SERVICE_BUS, AZURE_BLOB, FIRESTORE, PUBSUB, STORAGE.", ex);
        }
    }

    public class ConfigDoesNotExistException
    extends ApplicationException {
        public String configAlias;

        public ConfigDoesNotExistException(String configAlias) {
            this.configAlias = configAlias;
        }
    }
}

