/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.util.RB;

public class ValidationUtil {
    public static void validPositiveNumber(long l, String fieldName) {
        if (l < 0L) {
            throw new ValidationException(RB.getString(CloudService.class, "invalidPositiveNumber").replace("{fieldName}", fieldName));
        }
    }

    public static void validNumberInRange(long l, long min, long max, String fieldName) {
        if (l < min || l > max) {
            throw new ValidationException(RB.getString(CloudService.class, "invalidRange").replace("{fieldName}", fieldName).replace("{min}", String.valueOf(min)).replace("{max}", String.valueOf(max)));
        }
    }

    public static void validNonEmptyString(String value, String fieldName) {
        if (value == null || value.isEmpty()) {
            throw new ValidationException(RB.getString(CloudService.class, "emptyValueException").replace("{fieldName}", fieldName));
        }
    }

    public static void validNonBlankString(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new ValidationException(RB.getString(CloudService.class, "emptyValueException").replace("{fieldName}", fieldName));
        }
    }
}

