/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import java.util.Arrays;
import java.util.HashSet;

public enum DurationFormatValidator implements Validator
{
    INSTANCE;

    String[] allowedValues = new String[]{"h", "m", "M", "n", "s", "d"};
    HashSet<String> allowedValuesSet = new HashSet<String>(Arrays.asList(this.allowedValues));

    public boolean validate(Object object) {
        try {
            int length;
            if (object == null) {
                return true;
            }
            String stringDuration = Cast._String(object);
            String unit = stringDuration.substring((length = stringDuration.length()) - 1);
            if (!this.allowedValuesSet.contains(unit)) {
                throw new FieldValidationFailedException("Time Unit not allowed for duration type. Allowed values : 'h' , 'm', 'M', 's' , 'd', 'n'");
            }
            int response = 1;
            response = Integer.parseInt(stringDuration.substring(0, length - 1));
            return true;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect syntax for duration ", ex);
        }
    }
}

