/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import java.util.List;
import java.util.Set;

public class EnumListValidator
implements Validator {
    Set<String> allowedValues;
    String fieldName;

    public EnumListValidator(Set<String> allowedValues, String fieldName) {
        this.allowedValues = allowedValues;
        this.fieldName = fieldName;
    }

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            List values = Cast._List(obj);
            if (values.size() > this.allowedValues.size()) {
                throw new FieldValidationFailedException("Field 'rights' can have maximum " + this.allowedValues.size() + " values.");
            }
            if (this.allowedValues.contains(values)) {
                return true;
            }
            values.forEach(value -> {
                if (!this.allowedValues.contains(value)) {
                    throw new FieldValidationFailedException("Invalid value for field " + this.fieldName + " " + value);
                }
            });
            return true;
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect type for field name " + this.fieldName, ex);
        }
    }
}

