/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.validator;

import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import coldfusion.runtime.Cast;
import java.util.Set;

public class EnumValidator
implements Validator {
    Set<String> allowedValues;
    String fieldName;

    public EnumValidator(Set<String> allowedValues, String fieldName) {
        this.allowedValues = allowedValues;
        this.fieldName = fieldName;
    }

    public boolean validate(Object obj) {
        try {
            if (obj == null) {
                return true;
            }
            String val = Cast._String(obj);
            if (this.allowedValues.contains(val)) {
                return true;
            }
            throw new FieldValidationFailedException("Invalid value for field " + this.fieldName + " " + val);
        }
        catch (ClassCastException ex) {
            throw new FieldValidationFailedException("Incorrect type for field name " + this.fieldName, ex);
        }
    }
}

