/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFNumber;
import coldfusion.runtime.DoubleParser;

public class CFDouble
extends Number
implements CFNumber {
    private static final long serialVersionUID = 1L;
    private final double value;
    private final String image;

    public CFDouble(double val, String image) {
        this.value = val;
        this.image = image;
    }

    public static double parseDouble(String s) throws NumberFormatException {
        char last = s.charAt(s.length() - 1);
        if (last == 'F' || last == 'D' || last == 'd' || last == 'f' || last <= ' ' || s.charAt(0) <= ' ') {
            throw new NumberFormatException(s);
        }
        return Double.parseDouble(s);
    }

    public static Double parseDouble(String s, boolean throwError) throws NumberFormatException {
        char last = s.charAt(s.length() - 1);
        if (last == 'F' || last == 'D' || last == 'd' || last == 'f' || last <= ' ' || s.charAt(0) <= ' ') {
            if (throwError) {
                throw new NumberFormatException(s);
            }
            return null;
        }
        if (throwError) {
            return Double.parseDouble(s);
        }
        return DoubleParser.parseDouble(s);
    }

    public String toString() {
        return this.image;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Object unwrap() {
        return this.value;
    }
}

