/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Struct;
import coldfusion.xml.XmlNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ObjectDuplicator {
    public static Object duplicate(Object obj) throws IllegalAccessException {
        return ObjectDuplicator.duplicate(obj, null);
    }

    public static Object duplicate(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        Object newObj;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number || obj instanceof Boolean || obj instanceof String || obj.getClass().isPrimitive()) {
            return obj;
        }
        if (obj instanceof Throwable) {
            return Cast._Map(obj);
        }
        if (refCache == null) {
            refCache = new IdentityHashMap();
        }
        if ((newObj = refCache.get(obj)) == null) {
            newObj = ObjectDuplicator._duplicate(obj, refCache);
            refCache.put(obj, newObj);
        }
        return newObj;
    }

    private static Object _duplicate(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof Array) {
            return new Array().addAll((Collection)((Array)obj));
        }
        if (obj.getClass().isArray()) {
            return ObjectDuplicator.duplicateJavaArray(obj, refCache);
        }
        if (obj instanceof List) {
            return ObjectDuplicator.duplicateList((List)obj, refCache);
        }
        if (obj instanceof XmlNodeList) {
            return ((XmlNodeList)obj).Duplicate();
        }
        if (obj instanceof Map) {
            Map scopeObj = (Map)obj;
            Struct structCopy = null;
            if (scopeObj instanceof Struct) {
                structCopy = new Struct();
            }
            refCache.put(obj, structCopy);
            for (Map.Entry e : scopeObj.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                structCopy.put(key, ObjectDuplicator.duplicate(value, refCache));
            }
            return structCopy;
        }
        return obj;
    }

    private static List duplicateList(List original, IdentityHashMap refCache) throws IllegalAccessException {
        ArrayList<Object> copy = new ArrayList<Object>(original.size());
        refCache.put(original, copy);
        ListIterator e = original.listIterator();
        while (e.hasNext()) {
            Object curObj = e.next();
            copy.add(ObjectDuplicator.duplicate(curObj, refCache));
        }
        return copy;
    }

    private static Object duplicateJavaArray(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        int len = java.lang.reflect.Array.getLength(obj);
        Object dst = java.lang.reflect.Array.newInstance(obj.getClass().getComponentType(), len);
        refCache.put(obj, dst);
        if (obj.getClass().getComponentType().isPrimitive()) {
            System.arraycopy(obj, 0, dst, 0, len);
        } else {
            for (int i = 0; i < len; ++i) {
                Object src = java.lang.reflect.Array.get(obj, i);
                java.lang.reflect.Array.set(dst, i, ObjectDuplicator.duplicate(src, refCache));
            }
        }
        return dst;
    }

    public static class UnableToDuplicateCFCException
    extends ExpressionException {
        public UnableToDuplicateCFCException(Throwable th) {
            super(th);
        }
    }
}

