/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;

public class SystemInfo {
    private static final String Java2DSVGSupportClass = "com.gp.java2d.ExGraphicsEnvironment";
    private static final int SQlLinkPort = 20007;
    private static final boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    private static final boolean isAIX = System.getProperty("os.name").toUpperCase().startsWith("AIX");
    private static final boolean isMac = System.getProperty("os.name").toUpperCase().indexOf("MAC") != -1;
    private static final boolean isSolaris = System.getProperty("os.name").toUpperCase().startsWith("SUNOS") || System.getProperty("os.name").toUpperCase().startsWith("SOLARIS");
    private static final boolean isLinux = System.getProperty("os.name").toUpperCase().startsWith("LINUX");
    private static final boolean isPPC = System.getProperty("os.arch").toUpperCase().indexOf("PPC") != -1;
    private static String serverInfo;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsCFXEnabled() {
        boolean rc = true;
        try {
            if (!isPPC) return rc;
        }
        catch (Throwable tLibraryProblem) {
            return false;
        }
        return rc;
    }

    public static boolean Is64Bit() {
        boolean is64bit = false;
        String osarch = System.getProperty("os.arch");
        String osname = System.getProperty("os.name");
        if (osarch.indexOf("64") != -1) {
            is64bit = true;
        }
        return is64bit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsNativeRegistryEnabled() {
        boolean rc = true;
        try {
            if (!isPPC) return rc;
        }
        catch (Throwable tLibraryProblem) {
            return false;
        }
        return rc;
    }

    public static boolean IsGraphEnabled() {
        boolean rc = false;
        if (SystemInfo.isWindows()) {
            return true;
        }
        String env = System.getProperty("java.awt.graphicsenv");
        if (env != null && env.equals(Java2DSVGSupportClass)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ClassLoader systemcl = cl.getSystemClassLoader();
            try {
                Class.forName(Java2DSVGSupportClass, true, systemcl);
                rc = true;
            }
            catch (Exception e) {
                rc = false;
            }
        }
        return rc;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isAIX() {
        return isAIX;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isPPC() {
        return isPPC;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean IsSQLLinkEnabled(String sLinkServer, String port) {
        boolean rCode = true;
        Connection con = null;
        try {
            Class.forName("macromedia.jdbc.MacromediaDriver");
            con = DriverManager.getConnection("jdbc:sequelink:odbcsocket://" + sLinkServer + ":" + port + ";serverDatasource=usme", "foo", "");
            boolean bl = con.isClosed();
            if (con == null) return rCode;
        }
        catch (SQLException sqle) {
            int errorCode = sqle.getErrorCode();
            if (errorCode == 2306) {
                rCode = false;
            }
            if (con == null) return rCode;
            SystemInfo.close(con);
            return rCode;
        }
        catch (ClassNotFoundException cnfe) {
            rCode = false;
            return rCode;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (con != null) {
                SystemInfo.close(con);
            }
        }
        SystemInfo.close(con);
        return rCode;
    }

    public static boolean IsSQLLinkEnabled() {
        return SystemInfo.IsSQLLinkEnabled("localhost", "20008");
    }

    private static void close(Connection con) {
        try {
            con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Hashtable getSystemStatus() {
        Hashtable<String, Boolean> results = new Hashtable<String, Boolean>();
        results.put("CFX", SystemInfo.IsCFXEnabled());
        results.put("Graph", SystemInfo.IsGraphEnabled());
        results.put("NativeRegistry", SystemInfo.IsNativeRegistryEnabled());
        results.put("SQLLink", SystemInfo.IsSQLLinkEnabled());
        return results;
    }

    public static String getCFXNeoLibName() {
        if (!SystemInfo.isWindows()) {
            String arch = System.getProperty("os.arch");
            String osname = System.getProperty("os.name");
            if (SystemInfo.isMac()) {
                return "libCFXNeo.jnilib";
            }
            if (osname.indexOf("HP-UX") != -1) {
                return "libCFXNeo.sl";
            }
            if (arch.indexOf("ppc") != -1 && SystemInfo.isLinux()) {
                return "libCFXNeo_ppclinux64.so";
            }
            return "libCFXNeo.so";
        }
        return "CFXNeo.dll";
    }
}

